/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.MergingSnapshotProducer;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.SnapshotUtil;

class BaseRowDelta
extends MergingSnapshotProducer<RowDelta>
implements RowDelta {
    private Long startingSnapshotId = null;
    private final CharSequenceSet referencedDataFiles = CharSequenceSet.empty();
    private boolean validateDeletes = false;
    private Expression conflictDetectionFilter = Expressions.alwaysTrue();
    private boolean validateNewDataFiles = false;
    private boolean validateNewDeleteFiles = false;

    BaseRowDelta(String tableName, TableOperations ops) {
        super(tableName, ops);
    }

    @Override
    protected BaseRowDelta self() {
        return this;
    }

    @Override
    protected String operation() {
        if (this.addsDeleteFiles() && !this.addsDataFiles()) {
            return "delete";
        }
        return "overwrite";
    }

    public RowDelta addRows(DataFile inserts) {
        this.add(inserts);
        return this;
    }

    public RowDelta addDeletes(DeleteFile deletes) {
        this.add(deletes);
        return this;
    }

    public RowDelta removeDeletes(DeleteFile deletes) {
        this.delete(deletes);
        return this;
    }

    public RowDelta validateFromSnapshot(long snapshotId) {
        this.startingSnapshotId = snapshotId;
        return this;
    }

    public RowDelta validateDeletedFiles() {
        this.validateDeletes = true;
        return this;
    }

    public RowDelta validateDataFilesExist(Iterable<? extends CharSequence> referencedFiles) {
        referencedFiles.forEach(arg_0 -> ((CharSequenceSet)this.referencedDataFiles).add(arg_0));
        return this;
    }

    public RowDelta conflictDetectionFilter(Expression newConflictDetectionFilter) {
        Preconditions.checkArgument((newConflictDetectionFilter != null ? 1 : 0) != 0, (Object)"Conflict detection filter cannot be null");
        this.conflictDetectionFilter = newConflictDetectionFilter;
        return this;
    }

    public RowDelta validateNoConflictingDataFiles() {
        this.validateNewDataFiles = true;
        return this;
    }

    public RowDelta validateNoConflictingDeleteFiles() {
        this.validateNewDeleteFiles = true;
        return this;
    }

    public RowDelta toBranch(String branch) {
        this.targetBranch(branch);
        return this;
    }

    @Override
    protected void validate(TableMetadata base, Snapshot parent) {
        if (parent != null) {
            if (this.startingSnapshotId != null) {
                Preconditions.checkArgument((boolean)SnapshotUtil.isAncestorOf(parent.snapshotId(), (long)this.startingSnapshotId, base::snapshot), (String)"Snapshot %s is not an ancestor of %s", (Object)this.startingSnapshotId, (long)parent.snapshotId());
            }
            if (!this.referencedDataFiles.isEmpty()) {
                this.validateDataFilesExist(base, this.startingSnapshotId, this.referencedDataFiles, !this.validateDeletes, this.conflictDetectionFilter, parent);
            }
            if (this.validateNewDataFiles) {
                this.validateAddedDataFiles(base, this.startingSnapshotId, this.conflictDetectionFilter, parent);
            }
            if (this.validateNewDeleteFiles) {
                this.validateNoNewDeleteFiles(base, this.startingSnapshotId, this.conflictDetectionFilter, parent);
            }
        }
    }
}

