/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestGroup;
import org.apache.iceberg.ManifestLists;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

class BaseSnapshot
implements Snapshot {
    private final long snapshotId;
    private final Long parentId;
    private final long sequenceNumber;
    private final long timestampMillis;
    private final String manifestListLocation;
    private final String operation;
    private final Map<String, String> summary;
    private final Integer schemaId;
    private final String[] v1ManifestLocations;
    private transient List<ManifestFile> allManifests = null;
    private transient List<ManifestFile> dataManifests = null;
    private transient List<ManifestFile> deleteManifests = null;
    private transient List<DataFile> addedDataFiles = null;
    private transient List<DataFile> removedDataFiles = null;
    private transient List<DeleteFile> addedDeleteFiles = null;
    private transient List<DeleteFile> removedDeleteFiles = null;

    BaseSnapshot(long sequenceNumber, long snapshotId, Long parentId, long timestampMillis, String operation, Map<String, String> summary, Integer schemaId, String manifestList) {
        this.sequenceNumber = sequenceNumber;
        this.snapshotId = snapshotId;
        this.parentId = parentId;
        this.timestampMillis = timestampMillis;
        this.operation = operation;
        this.summary = summary;
        this.schemaId = schemaId;
        this.manifestListLocation = manifestList;
        this.v1ManifestLocations = null;
    }

    BaseSnapshot(long sequenceNumber, long snapshotId, Long parentId, long timestampMillis, String operation, Map<String, String> summary, Integer schemaId, String[] v1ManifestLocations) {
        this.sequenceNumber = sequenceNumber;
        this.snapshotId = snapshotId;
        this.parentId = parentId;
        this.timestampMillis = timestampMillis;
        this.operation = operation;
        this.summary = summary;
        this.schemaId = schemaId;
        this.manifestListLocation = null;
        this.v1ManifestLocations = v1ManifestLocations;
    }

    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public Long parentId() {
        return this.parentId;
    }

    public long timestampMillis() {
        return this.timestampMillis;
    }

    public String operation() {
        return this.operation;
    }

    public Map<String, String> summary() {
        return this.summary;
    }

    public Integer schemaId() {
        return this.schemaId;
    }

    private void cacheManifests(FileIO fileIO) {
        if (fileIO == null) {
            throw new IllegalArgumentException("Cannot cache changes: FileIO is null");
        }
        if (this.allManifests == null && this.v1ManifestLocations != null) {
            this.allManifests = Lists.transform(Arrays.asList(this.v1ManifestLocations), location -> new GenericManifestFile(fileIO.newInputFile(location), 0));
        }
        if (this.allManifests == null) {
            this.allManifests = ManifestLists.read(fileIO.newInputFile(this.manifestListLocation));
        }
        if (this.dataManifests == null || this.deleteManifests == null) {
            this.dataManifests = ImmutableList.copyOf((Iterable)Iterables.filter(this.allManifests, manifest -> manifest.content() == ManifestContent.DATA));
            this.deleteManifests = ImmutableList.copyOf((Iterable)Iterables.filter(this.allManifests, manifest -> manifest.content() == ManifestContent.DELETES));
        }
    }

    public List<ManifestFile> allManifests(FileIO fileIO) {
        if (this.allManifests == null) {
            this.cacheManifests(fileIO);
        }
        return this.allManifests;
    }

    public List<ManifestFile> dataManifests(FileIO fileIO) {
        if (this.dataManifests == null) {
            this.cacheManifests(fileIO);
        }
        return this.dataManifests;
    }

    public List<ManifestFile> deleteManifests(FileIO fileIO) {
        if (this.deleteManifests == null) {
            this.cacheManifests(fileIO);
        }
        return this.deleteManifests;
    }

    public List<DataFile> addedDataFiles(FileIO fileIO) {
        if (this.addedDataFiles == null) {
            this.cacheDataFileChanges(fileIO);
        }
        return this.addedDataFiles;
    }

    public List<DataFile> removedDataFiles(FileIO fileIO) {
        if (this.removedDataFiles == null) {
            this.cacheDataFileChanges(fileIO);
        }
        return this.removedDataFiles;
    }

    public Iterable<DeleteFile> addedDeleteFiles(FileIO fileIO) {
        if (this.addedDeleteFiles == null) {
            this.cacheDeleteFileChanges(fileIO);
        }
        return this.addedDeleteFiles;
    }

    public Iterable<DeleteFile> removedDeleteFiles(FileIO fileIO) {
        if (this.removedDeleteFiles == null) {
            this.cacheDeleteFileChanges(fileIO);
        }
        return this.removedDeleteFiles;
    }

    public String manifestListLocation() {
        return this.manifestListLocation;
    }

    private void cacheDeleteFileChanges(FileIO fileIO) {
        Preconditions.checkArgument((fileIO != null ? 1 : 0) != 0, (Object)"Cannot cache delete file changes: FileIO is null");
        ImmutableList.Builder adds = ImmutableList.builder();
        ImmutableList.Builder deletes = ImmutableList.builder();
        Iterable changedManifests = Iterables.filter(this.deleteManifests(fileIO), manifest -> Objects.equal((Object)manifest.snapshotId(), (Object)this.snapshotId));
        for (ManifestFile manifest2 : changedManifests) {
            try {
                ManifestReader<DeleteFile> reader = ManifestFiles.readDeleteManifest(manifest2, fileIO, null);
                try {
                    for (ManifestEntry entry : reader.entries()) {
                        switch (entry.status()) {
                            case ADDED: {
                                adds.add((Object)((DeleteFile)((DeleteFile)entry.file()).copy()));
                                break;
                            }
                            case DELETED: {
                                deletes.add((Object)((DeleteFile)((DeleteFile)entry.file()).copyWithoutStats()));
                                break;
                            }
                        }
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close manifest reader", e);
            }
        }
        this.addedDeleteFiles = adds.build();
        this.removedDeleteFiles = deletes.build();
    }

    private void cacheDataFileChanges(FileIO fileIO) {
        Preconditions.checkArgument((fileIO != null ? 1 : 0) != 0, (Object)"Cannot cache data file changes: FileIO is null");
        ImmutableList.Builder adds = ImmutableList.builder();
        ImmutableList.Builder deletes = ImmutableList.builder();
        Iterable changedManifests = Iterables.filter(this.dataManifests(fileIO), manifest -> Objects.equal((Object)manifest.snapshotId(), (Object)this.snapshotId));
        try (CloseableIterable<ManifestEntry<DataFile>> entries = new ManifestGroup(fileIO, changedManifests).ignoreExisting().entries();){
            block11: for (ManifestEntry entry : entries) {
                switch (entry.status()) {
                    case ADDED: {
                        adds.add((Object)((DataFile)((DataFile)entry.file()).copy()));
                        continue block11;
                    }
                    case DELETED: {
                        deletes.add((Object)((DataFile)((DataFile)entry.file()).copyWithoutStats()));
                        continue block11;
                    }
                }
                throw new IllegalStateException("Unexpected entry status, not added or deleted: " + entry);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to close entries while caching changes", new Object[0]);
        }
        this.addedDataFiles = adds.build();
        this.removedDataFiles = deletes.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BaseSnapshot) {
            BaseSnapshot other = (BaseSnapshot)o;
            return this.snapshotId == other.snapshotId() && Objects.equal((Object)this.parentId, (Object)other.parentId()) && this.sequenceNumber == other.sequenceNumber() && this.timestampMillis == other.timestampMillis() && Objects.equal((Object)this.schemaId, (Object)other.schemaId());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.snapshotId, this.parentId, this.sequenceNumber, this.timestampMillis, this.schemaId});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.snapshotId).add("timestamp_ms", this.timestampMillis).add("operation", (Object)this.operation).add("summary", this.summary).add("manifest-list", (Object)this.manifestListLocation).add("schema-id", (Object)this.schemaId).toString();
    }
}

