/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.ScanMetrics;
import org.apache.iceberg.metrics.ScanMetricsUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ArrayUtil;
import org.apache.iceberg.util.ContentFileUtil;
import org.apache.iceberg.util.PartitionMap;
import org.apache.iceberg.util.PartitionSet;
import org.apache.iceberg.util.Tasks;

class DeleteFileIndex {
    private static final DeleteFile[] EMPTY_DELETES = new DeleteFile[0];
    private final EqualityDeletes globalDeletes;
    private final PartitionMap<EqualityDeletes> eqDeletesByPartition;
    private final PartitionMap<PositionDeletes> posDeletesByPartition;
    private final Map<String, PositionDeletes> posDeletesByPath;
    private final boolean hasEqDeletes;
    private final boolean hasPosDeletes;
    private final boolean isEmpty;

    private DeleteFileIndex(EqualityDeletes globalDeletes, PartitionMap<EqualityDeletes> eqDeletesByPartition, PartitionMap<PositionDeletes> posDeletesByPartition, Map<String, PositionDeletes> posDeletesByPath) {
        this.globalDeletes = globalDeletes;
        this.eqDeletesByPartition = eqDeletesByPartition;
        this.posDeletesByPartition = posDeletesByPartition;
        this.posDeletesByPath = posDeletesByPath;
        this.hasEqDeletes = globalDeletes != null || eqDeletesByPartition != null;
        this.hasPosDeletes = posDeletesByPartition != null || posDeletesByPath != null;
        this.isEmpty = !this.hasEqDeletes && !this.hasPosDeletes;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean hasEqualityDeletes() {
        return this.hasEqDeletes;
    }

    public boolean hasPositionDeletes() {
        return this.hasPosDeletes;
    }

    public Iterable<DeleteFile> referencedDeleteFiles() {
        Iterable<Object> deleteFiles = Collections.emptyList();
        if (this.globalDeletes != null) {
            deleteFiles = Iterables.concat(deleteFiles, this.globalDeletes.referencedDeleteFiles());
        }
        if (this.eqDeletesByPartition != null) {
            for (EqualityDeletes equalityDeletes : this.eqDeletesByPartition.values()) {
                deleteFiles = Iterables.concat(deleteFiles, equalityDeletes.referencedDeleteFiles());
            }
        }
        if (this.posDeletesByPartition != null) {
            for (PositionDeletes positionDeletes : this.posDeletesByPartition.values()) {
                deleteFiles = Iterables.concat(deleteFiles, positionDeletes.referencedDeleteFiles());
            }
        }
        if (this.posDeletesByPath != null) {
            for (PositionDeletes positionDeletes : this.posDeletesByPath.values()) {
                deleteFiles = Iterables.concat(deleteFiles, positionDeletes.referencedDeleteFiles());
            }
        }
        return deleteFiles;
    }

    DeleteFile[] forEntry(ManifestEntry<DataFile> entry) {
        return this.forDataFile(entry.dataSequenceNumber(), entry.file());
    }

    DeleteFile[] forDataFile(DataFile file) {
        return this.forDataFile(file.dataSequenceNumber(), file);
    }

    DeleteFile[] forDataFile(long sequenceNumber, DataFile file) {
        if (this.isEmpty) {
            return EMPTY_DELETES;
        }
        DeleteFile[] global = this.findGlobalDeletes(sequenceNumber, file);
        DeleteFile[] eqPartition = this.findEqPartitionDeletes(sequenceNumber, file);
        DeleteFile[] posPartition = this.findPosPartitionDeletes(sequenceNumber, file);
        DeleteFile[] posPath = this.findPathDeletes(sequenceNumber, file);
        return DeleteFileIndex.concat(global, eqPartition, posPartition, posPath);
    }

    private DeleteFile[] findGlobalDeletes(long seq, DataFile dataFile) {
        return this.globalDeletes == null ? EMPTY_DELETES : this.globalDeletes.filter(seq, dataFile);
    }

    private DeleteFile[] findPosPartitionDeletes(long seq, DataFile dataFile) {
        if (this.posDeletesByPartition == null) {
            return EMPTY_DELETES;
        }
        PositionDeletes deletes = this.posDeletesByPartition.get(dataFile.specId(), dataFile.partition());
        return deletes == null ? EMPTY_DELETES : deletes.filter(seq);
    }

    private DeleteFile[] findEqPartitionDeletes(long seq, DataFile dataFile) {
        if (this.eqDeletesByPartition == null) {
            return EMPTY_DELETES;
        }
        EqualityDeletes deletes = this.eqDeletesByPartition.get(dataFile.specId(), dataFile.partition());
        return deletes == null ? EMPTY_DELETES : deletes.filter(seq, dataFile);
    }

    private DeleteFile[] findPathDeletes(long seq, DataFile dataFile) {
        if (this.posDeletesByPath == null) {
            return EMPTY_DELETES;
        }
        PositionDeletes deletes = this.posDeletesByPath.get(dataFile.location());
        return deletes == null ? EMPTY_DELETES : deletes.filter(seq);
    }

    private static boolean canContainEqDeletesForFile(DataFile dataFile, EqualityDeleteFile deleteFile) {
        Map dataLowers = dataFile.lowerBounds();
        Map dataUppers = dataFile.upperBounds();
        boolean checkRanges = dataLowers != null && dataUppers != null && deleteFile.hasLowerAndUpperBounds();
        Map dataNullCounts = dataFile.nullValueCounts();
        Map dataValueCounts = dataFile.valueCounts();
        Map<Integer, Long> deleteNullCounts = deleteFile.nullValueCounts();
        Map<Integer, Long> deleteValueCounts = deleteFile.valueCounts();
        for (Types.NestedField field : deleteFile.equalityFields()) {
            if (!field.type().isPrimitiveType() || DeleteFileIndex.containsNull(dataNullCounts, field) && DeleteFileIndex.containsNull(deleteNullCounts, field)) continue;
            if (DeleteFileIndex.allNull(dataNullCounts, dataValueCounts, field) && DeleteFileIndex.allNonNull(deleteNullCounts, field)) {
                return false;
            }
            if (DeleteFileIndex.allNull(deleteNullCounts, deleteValueCounts, field) && DeleteFileIndex.allNonNull(dataNullCounts, field)) {
                return false;
            }
            if (!checkRanges) continue;
            int id = field.fieldId();
            ByteBuffer dataLower = (ByteBuffer)dataLowers.get(id);
            ByteBuffer dataUpper = (ByteBuffer)dataUppers.get(id);
            Object deleteLower = deleteFile.lowerBound(id);
            Object deleteUpper = deleteFile.upperBound(id);
            if (dataLower == null || dataUpper == null || deleteLower == null || deleteUpper == null || DeleteFileIndex.rangesOverlap(field, dataLower, dataUpper, deleteLower, deleteUpper)) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean rangesOverlap(Types.NestedField field, ByteBuffer dataLowerBuf, ByteBuffer dataUpperBuf, T deleteLower, T deleteUpper) {
        Object dataLower;
        Type.PrimitiveType type = field.type().asPrimitiveType();
        Comparator comparator = Comparators.forType((Type.PrimitiveType)type);
        if (comparator.compare(dataLower = Conversions.fromByteBuffer((Type)type, (ByteBuffer)dataLowerBuf), deleteUpper) > 0) {
            return false;
        }
        Object dataUpper = Conversions.fromByteBuffer((Type)type, (ByteBuffer)dataUpperBuf);
        return comparator.compare(deleteLower, dataUpper) <= 0;
    }

    private static boolean allNonNull(Map<Integer, Long> nullValueCounts, Types.NestedField field) {
        if (field.isRequired()) {
            return true;
        }
        if (nullValueCounts == null) {
            return false;
        }
        Long nullValueCount = nullValueCounts.get(field.fieldId());
        if (nullValueCount == null) {
            return false;
        }
        return nullValueCount <= 0L;
    }

    private static boolean allNull(Map<Integer, Long> nullValueCounts, Map<Integer, Long> valueCounts, Types.NestedField field) {
        if (field.isRequired()) {
            return false;
        }
        if (nullValueCounts == null || valueCounts == null) {
            return false;
        }
        Long nullValueCount = nullValueCounts.get(field.fieldId());
        Long valueCount = valueCounts.get(field.fieldId());
        if (nullValueCount == null || valueCount == null) {
            return false;
        }
        return nullValueCount.equals(valueCount);
    }

    private static boolean containsNull(Map<Integer, Long> nullValueCounts, Types.NestedField field) {
        if (field.isRequired()) {
            return false;
        }
        if (nullValueCounts == null) {
            return true;
        }
        Long nullValueCount = nullValueCounts.get(field.fieldId());
        if (nullValueCount == null) {
            return true;
        }
        return nullValueCount > 0L;
    }

    static Builder builderFor(FileIO io, Iterable<ManifestFile> deleteManifests) {
        return new Builder(io, Sets.newHashSet(deleteManifests));
    }

    static Builder builderFor(Iterable<DeleteFile> deleteFiles) {
        return new Builder(deleteFiles);
    }

    private static int findStartIndex(long[] seqs, long seq) {
        int start;
        int pos = Arrays.binarySearch(seqs, seq);
        if (pos < 0) {
            start = -(pos + 1);
        } else {
            for (start = pos; start > 0 && seqs[start - 1] >= seq; --start) {
            }
        }
        return start;
    }

    private static DeleteFile[] concat(DeleteFile[] ... deletes) {
        return ArrayUtil.concat(DeleteFile.class, deletes);
    }

    private static class EqualityDeleteFile {
        private final PartitionSpec spec;
        private final DeleteFile wrapped;
        private final long applySequenceNumber;
        private volatile List<Types.NestedField> equalityFields = null;
        private volatile Map<Integer, Object> convertedLowerBounds = null;
        private volatile Map<Integer, Object> convertedUpperBounds = null;

        EqualityDeleteFile(PartitionSpec spec, DeleteFile file) {
            this.spec = spec;
            this.wrapped = file;
            this.applySequenceNumber = this.wrapped.dataSequenceNumber() - 1L;
        }

        public DeleteFile wrapped() {
            return this.wrapped;
        }

        public long applySequenceNumber() {
            return this.applySequenceNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Types.NestedField> equalityFields() {
            if (this.equalityFields == null) {
                EqualityDeleteFile equalityDeleteFile = this;
                synchronized (equalityDeleteFile) {
                    if (this.equalityFields == null) {
                        ArrayList fields = Lists.newArrayList();
                        Iterator iterator = this.wrapped.equalityFieldIds().iterator();
                        while (iterator.hasNext()) {
                            int id = (Integer)iterator.next();
                            Types.NestedField field = this.spec.schema().findField(id);
                            fields.add(field);
                        }
                        this.equalityFields = fields;
                    }
                }
            }
            return this.equalityFields;
        }

        public Map<Integer, Long> valueCounts() {
            return this.wrapped.valueCounts();
        }

        public Map<Integer, Long> nullValueCounts() {
            return this.wrapped.nullValueCounts();
        }

        public boolean hasLowerAndUpperBounds() {
            return this.wrapped.lowerBounds() != null && this.wrapped.upperBounds() != null;
        }

        public <T> T lowerBound(int id) {
            return (T)this.lowerBounds().get(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<Integer, Object> lowerBounds() {
            if (this.convertedLowerBounds == null) {
                EqualityDeleteFile equalityDeleteFile = this;
                synchronized (equalityDeleteFile) {
                    if (this.convertedLowerBounds == null) {
                        this.convertedLowerBounds = this.convertBounds(this.wrapped.lowerBounds());
                    }
                }
            }
            return this.convertedLowerBounds;
        }

        public <T> T upperBound(int id) {
            return (T)this.upperBounds().get(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<Integer, Object> upperBounds() {
            if (this.convertedUpperBounds == null) {
                EqualityDeleteFile equalityDeleteFile = this;
                synchronized (equalityDeleteFile) {
                    if (this.convertedUpperBounds == null) {
                        this.convertedUpperBounds = this.convertBounds(this.wrapped.upperBounds());
                    }
                }
            }
            return this.convertedUpperBounds;
        }

        private Map<Integer, Object> convertBounds(Map<Integer, ByteBuffer> bounds) {
            HashMap converted = Maps.newHashMap();
            if (bounds != null) {
                for (Types.NestedField field : this.equalityFields()) {
                    ByteBuffer bound;
                    int id = field.fieldId();
                    Type type = this.spec.schema().findField(id).type();
                    if (!type.isPrimitiveType() || (bound = bounds.get(id)) == null) continue;
                    converted.put(id, Conversions.fromByteBuffer((Type)type, (ByteBuffer)bound));
                }
            }
            return converted;
        }
    }

    static class EqualityDeletes {
        private static final Comparator<EqualityDeleteFile> SEQ_COMPARATOR = Comparator.comparingLong(EqualityDeleteFile::applySequenceNumber);
        private static final EqualityDeleteFile[] EMPTY_EQUALITY_DELETES = new EqualityDeleteFile[0];
        private long[] seqs = null;
        private EqualityDeleteFile[] files = null;
        private volatile List<EqualityDeleteFile> buffer = Lists.newArrayList();

        EqualityDeletes() {
        }

        public void add(PartitionSpec spec, DeleteFile file) {
            Preconditions.checkState((this.buffer != null ? 1 : 0) != 0, (Object)"Can't add files upon indexing");
            this.buffer.add(new EqualityDeleteFile(spec, file));
        }

        public DeleteFile[] filter(long seq, DataFile dataFile) {
            this.indexIfNeeded();
            int start = DeleteFileIndex.findStartIndex(this.seqs, seq);
            if (start >= this.files.length) {
                return EMPTY_DELETES;
            }
            ArrayList matchingFiles = Lists.newArrayList();
            for (int index = start; index < this.files.length; ++index) {
                EqualityDeleteFile file = this.files[index];
                if (!DeleteFileIndex.canContainEqDeletesForFile(dataFile, file)) continue;
                matchingFiles.add(file.wrapped());
            }
            return matchingFiles.toArray(EMPTY_DELETES);
        }

        public Iterable<DeleteFile> referencedDeleteFiles() {
            this.indexIfNeeded();
            return Iterables.transform(Arrays.asList(this.files), EqualityDeleteFile::wrapped);
        }

        public boolean isEmpty() {
            this.indexIfNeeded();
            return this.files.length == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void indexIfNeeded() {
            if (this.buffer != null) {
                EqualityDeletes equalityDeletes = this;
                synchronized (equalityDeletes) {
                    if (this.buffer != null) {
                        this.files = EqualityDeletes.indexFiles(this.buffer);
                        this.seqs = EqualityDeletes.indexSeqs(this.files);
                        this.buffer = null;
                    }
                }
            }
        }

        private static EqualityDeleteFile[] indexFiles(List<EqualityDeleteFile> list) {
            EqualityDeleteFile[] array = list.toArray(EMPTY_EQUALITY_DELETES);
            Arrays.sort(array, SEQ_COMPARATOR);
            return array;
        }

        private static long[] indexSeqs(EqualityDeleteFile[] files) {
            long[] seqs = new long[files.length];
            for (int index = 0; index < files.length; ++index) {
                seqs[index] = files[index].applySequenceNumber();
            }
            return seqs;
        }
    }

    static class PositionDeletes {
        private static final Comparator<DeleteFile> SEQ_COMPARATOR = Comparator.comparingLong(ContentFile::dataSequenceNumber);
        private long[] seqs = null;
        private DeleteFile[] files = null;
        private volatile List<DeleteFile> buffer = Lists.newArrayList();

        PositionDeletes() {
        }

        public void add(DeleteFile file) {
            Preconditions.checkState((this.buffer != null ? 1 : 0) != 0, (Object)"Can't add files upon indexing");
            this.buffer.add(file);
        }

        public DeleteFile[] filter(long seq) {
            this.indexIfNeeded();
            int start = DeleteFileIndex.findStartIndex(this.seqs, seq);
            if (start >= this.files.length) {
                return EMPTY_DELETES;
            }
            if (start == 0) {
                return this.files;
            }
            int matchingFilesCount = this.files.length - start;
            DeleteFile[] matchingFiles = new DeleteFile[matchingFilesCount];
            System.arraycopy(this.files, start, matchingFiles, 0, matchingFilesCount);
            return matchingFiles;
        }

        public Iterable<DeleteFile> referencedDeleteFiles() {
            this.indexIfNeeded();
            return Arrays.asList(this.files);
        }

        public boolean isEmpty() {
            this.indexIfNeeded();
            return this.files.length == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void indexIfNeeded() {
            if (this.buffer != null) {
                PositionDeletes positionDeletes = this;
                synchronized (positionDeletes) {
                    if (this.buffer != null) {
                        this.files = PositionDeletes.indexFiles(this.buffer);
                        this.seqs = PositionDeletes.indexSeqs(this.files);
                        this.buffer = null;
                    }
                }
            }
        }

        private static DeleteFile[] indexFiles(List<DeleteFile> list) {
            DeleteFile[] array = list.toArray(EMPTY_DELETES);
            Arrays.sort(array, SEQ_COMPARATOR);
            return array;
        }

        private static long[] indexSeqs(DeleteFile[] files) {
            long[] seqs = new long[files.length];
            for (int index = 0; index < files.length; ++index) {
                seqs[index] = files[index].dataSequenceNumber();
            }
            return seqs;
        }
    }

    static class Builder {
        private final FileIO io;
        private final Set<ManifestFile> deleteManifests;
        private final Iterable<DeleteFile> deleteFiles;
        private long minSequenceNumber = 0L;
        private Map<Integer, PartitionSpec> specsById = null;
        private Expression dataFilter = Expressions.alwaysTrue();
        private Expression partitionFilter = Expressions.alwaysTrue();
        private PartitionSet partitionSet = null;
        private boolean caseSensitive = true;
        private ExecutorService executorService = null;
        private ScanMetrics scanMetrics = ScanMetrics.noop();

        Builder(FileIO io, Set<ManifestFile> deleteManifests) {
            this.io = io;
            this.deleteManifests = Sets.newHashSet(deleteManifests);
            this.deleteFiles = null;
        }

        Builder(Iterable<DeleteFile> deleteFiles) {
            this.io = null;
            this.deleteManifests = null;
            this.deleteFiles = deleteFiles;
        }

        Builder afterSequenceNumber(long seq) {
            this.minSequenceNumber = seq;
            return this;
        }

        Builder specsById(Map<Integer, PartitionSpec> newSpecsById) {
            this.specsById = newSpecsById;
            return this;
        }

        Builder filterData(Expression newDataFilter) {
            Preconditions.checkArgument((this.deleteFiles == null ? 1 : 0) != 0, (Object)"Index constructed from files does not support data filters");
            this.dataFilter = Expressions.and((Expression)this.dataFilter, (Expression)newDataFilter);
            return this;
        }

        Builder filterPartitions(Expression newPartitionFilter) {
            Preconditions.checkArgument((this.deleteFiles == null ? 1 : 0) != 0, (Object)"Index constructed from files does not support partition filters");
            this.partitionFilter = Expressions.and((Expression)this.partitionFilter, (Expression)newPartitionFilter);
            return this;
        }

        Builder filterPartitions(PartitionSet newPartitionSet) {
            Preconditions.checkArgument((this.deleteFiles == null ? 1 : 0) != 0, (Object)"Index constructed from files does not support partition filters");
            this.partitionSet = newPartitionSet;
            return this;
        }

        Builder caseSensitive(boolean newCaseSensitive) {
            this.caseSensitive = newCaseSensitive;
            return this;
        }

        Builder planWith(ExecutorService newExecutorService) {
            this.executorService = newExecutorService;
            return this;
        }

        Builder scanMetrics(ScanMetrics newScanMetrics) {
            this.scanMetrics = newScanMetrics;
            return this;
        }

        private Iterable<DeleteFile> filterDeleteFiles() {
            return Iterables.filter(this.deleteFiles, file -> file.dataSequenceNumber() > this.minSequenceNumber);
        }

        private Collection<DeleteFile> loadDeleteFiles() {
            ConcurrentLinkedQueue<DeleteFile> files = new ConcurrentLinkedQueue<DeleteFile>();
            Tasks.foreach(this.deleteManifestReaders()).stopOnFailure().throwFailureWhenFinished().executeWith(this.executorService).run(deleteFile -> {
                try (CloseableIterable reader = deleteFile;){
                    for (ManifestEntry entry : reader) {
                        if (entry.dataSequenceNumber() <= this.minSequenceNumber) continue;
                        files.add((DeleteFile)((DeleteFile)entry.file()).copy());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e, "Failed to close", new Object[0]);
                }
            });
            return files;
        }

        DeleteFileIndex build() {
            Iterable<DeleteFile> files = this.deleteFiles != null ? this.filterDeleteFiles() : this.loadDeleteFiles();
            EqualityDeletes globalDeletes = new EqualityDeletes();
            PartitionMap<EqualityDeletes> eqDeletesByPartition = PartitionMap.create(this.specsById);
            PartitionMap<PositionDeletes> posDeletesByPartition = PartitionMap.create(this.specsById);
            HashMap posDeletesByPath = Maps.newHashMap();
            for (DeleteFile file : files) {
                switch (file.content()) {
                    case POSITION_DELETES: {
                        this.add(posDeletesByPath, posDeletesByPartition, file);
                        break;
                    }
                    case EQUALITY_DELETES: {
                        this.add(globalDeletes, eqDeletesByPartition, file);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported content: " + file.content());
                    }
                }
                ScanMetricsUtil.indexedDeleteFile(this.scanMetrics, file);
            }
            return new DeleteFileIndex(globalDeletes.isEmpty() ? null : globalDeletes, eqDeletesByPartition.isEmpty() ? null : eqDeletesByPartition, posDeletesByPartition.isEmpty() ? null : posDeletesByPartition, posDeletesByPath.isEmpty() ? null : posDeletesByPath);
        }

        private void add(Map<String, PositionDeletes> deletesByPath, PartitionMap<PositionDeletes> deletesByPartition, DeleteFile file) {
            PositionDeletes deletes;
            String path = ContentFileUtil.referencedDataFileLocation(file);
            if (path != null) {
                deletes = deletesByPath.computeIfAbsent(path, ignored -> new PositionDeletes());
            } else {
                int specId = file.specId();
                StructLike partition = file.partition();
                deletes = deletesByPartition.computeIfAbsent(specId, partition, PositionDeletes::new);
            }
            deletes.add(file);
        }

        private void add(EqualityDeletes globalDeletes, PartitionMap<EqualityDeletes> deletesByPartition, DeleteFile file) {
            EqualityDeletes deletes;
            PartitionSpec spec = this.specsById.get(file.specId());
            if (spec.isUnpartitioned()) {
                deletes = globalDeletes;
            } else {
                int specId = spec.specId();
                StructLike partition = file.partition();
                deletes = deletesByPartition.computeIfAbsent(specId, partition, EqualityDeletes::new);
            }
            deletes.add(spec, file);
        }

        private Iterable<CloseableIterable<ManifestEntry<DeleteFile>>> deleteManifestReaders() {
            LoadingCache evalCache = this.specsById == null ? null : Caffeine.newBuilder().build(specId -> {
                PartitionSpec spec = this.specsById.get(specId);
                return ManifestEvaluator.forPartitionFilter((Expression)Expressions.and((Expression)this.partitionFilter, (Expression)Projections.inclusive((PartitionSpec)spec, (boolean)this.caseSensitive).project(this.dataFilter)), (PartitionSpec)spec, (boolean)this.caseSensitive);
            });
            CloseableIterable closeableDeleteManifests = CloseableIterable.withNoopClose(this.deleteManifests);
            CloseableIterable matchingManifests = evalCache == null ? closeableDeleteManifests : CloseableIterable.filter((Counter)this.scanMetrics.skippedDeleteManifests(), (CloseableIterable)closeableDeleteManifests, manifest -> manifest.content() == ManifestContent.DELETES && (manifest.hasAddedFiles() || manifest.hasExistingFiles()) && ((ManifestEvaluator)evalCache.get((Object)manifest.partitionSpecId())).eval(manifest));
            matchingManifests = CloseableIterable.count((Counter)this.scanMetrics.scannedDeleteManifests(), (CloseableIterable)matchingManifests);
            return Iterables.transform((Iterable)matchingManifests, manifest -> ManifestFiles.readDeleteManifest(manifest, this.io, this.specsById).filterRows(this.dataFilter).filterPartitions(this.partitionFilter).filterPartitions(this.partitionSet).caseSensitive(this.caseSensitive).scanMetrics(this.scanMetrics).liveEntries());
        }
    }
}

