/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotProducer;
import org.apache.iceberg.SnapshotSummary;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.events.CreateSnapshotEvent;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.DataFileSet;

class FastAppend
extends SnapshotProducer<AppendFiles>
implements AppendFiles {
    private final String tableName;
    private final TableOperations ops;
    private final PartitionSpec spec;
    private final SnapshotSummary.Builder summaryBuilder = SnapshotSummary.builder();
    private final DataFileSet newFiles = DataFileSet.create();
    private final List<ManifestFile> appendManifests = Lists.newArrayList();
    private final List<ManifestFile> rewrittenAppendManifests = Lists.newArrayList();
    private List<ManifestFile> newManifests = null;
    private boolean hasNewFiles = false;

    FastAppend(String tableName, TableOperations ops) {
        super(ops);
        this.tableName = tableName;
        this.ops = ops;
        this.spec = ops.current().spec();
    }

    @Override
    protected AppendFiles self() {
        return this;
    }

    public AppendFiles set(String property, String value) {
        this.summaryBuilder.set(property, value);
        return this;
    }

    @Override
    protected String operation() {
        return "append";
    }

    @Override
    protected Map<String, String> summary() {
        this.summaryBuilder.setPartitionSummaryLimit(this.ops.current().propertyAsInt("write.summary.partition-limit", 0));
        return this.summaryBuilder.build();
    }

    public FastAppend appendFile(DataFile file) {
        Preconditions.checkNotNull((Object)file, (Object)"Invalid data file: null");
        if (this.newFiles.add((Object)file)) {
            this.hasNewFiles = true;
            this.summaryBuilder.addedFile(this.spec, file);
        }
        return this;
    }

    public FastAppend toBranch(String branch) {
        this.targetBranch(branch);
        return this;
    }

    public FastAppend appendManifest(ManifestFile manifest) {
        Preconditions.checkArgument((!manifest.hasExistingFiles() ? 1 : 0) != 0, (Object)"Cannot append manifest with existing files");
        Preconditions.checkArgument((!manifest.hasDeletedFiles() ? 1 : 0) != 0, (Object)"Cannot append manifest with deleted files");
        Preconditions.checkArgument((manifest.snapshotId() == null || manifest.snapshotId() == -1L ? 1 : 0) != 0, (Object)"Snapshot id must be assigned during commit");
        Preconditions.checkArgument((manifest.sequenceNumber() == -1L ? 1 : 0) != 0, (Object)"Sequence number must be assigned during commit");
        if (this.canInheritSnapshotId() && manifest.snapshotId() == null) {
            this.summaryBuilder.addedManifest(manifest);
            this.appendManifests.add(manifest);
        } else {
            ManifestFile copiedManifest = this.copyManifest(manifest);
            this.rewrittenAppendManifests.add(copiedManifest);
        }
        return this;
    }

    private ManifestFile copyManifest(ManifestFile manifest) {
        TableMetadata current = this.ops.current();
        InputFile toCopy = this.ops.io().newInputFile(manifest);
        EncryptedOutputFile newManifestFile = this.newManifestOutputFile();
        return ManifestFiles.copyAppendManifest(current.formatVersion(), manifest.partitionSpecId(), toCopy, current.specsById(), newManifestFile, this.snapshotId(), this.summaryBuilder);
    }

    @Override
    public List<ManifestFile> apply(TableMetadata base, Snapshot snapshot) {
        ArrayList manifests = Lists.newArrayList();
        try {
            List<ManifestFile> newWrittenManifests = this.writeNewManifests();
            if (newWrittenManifests != null) {
                manifests.addAll(newWrittenManifests);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to write manifest", new Object[0]);
        }
        Iterable appendManifestsWithMetadata = Iterables.transform((Iterable)Iterables.concat(this.appendManifests, this.rewrittenAppendManifests), manifest -> GenericManifestFile.copyOf(manifest).withSnapshotId(this.snapshotId()).build());
        Iterables.addAll((Collection)manifests, (Iterable)appendManifestsWithMetadata);
        if (snapshot != null) {
            manifests.addAll(snapshot.allManifests(this.ops.io()));
        }
        return manifests;
    }

    public Object updateEvent() {
        long snapshotId = this.snapshotId();
        Snapshot snapshot = this.ops.current().snapshot(snapshotId);
        long sequenceNumber = snapshot.sequenceNumber();
        return new CreateSnapshotEvent(this.tableName, this.operation(), snapshotId, sequenceNumber, snapshot.summary());
    }

    @Override
    protected void cleanUncommitted(Set<ManifestFile> committed) {
        if (this.newManifests != null) {
            boolean hasDeletes = false;
            for (ManifestFile manifest : this.newManifests) {
                if (committed.contains(manifest)) continue;
                this.deleteFile(manifest.path());
                hasDeletes = true;
            }
            if (hasDeletes) {
                this.newManifests = null;
            }
        }
        for (ManifestFile manifest : this.rewrittenAppendManifests) {
            if (committed.contains(manifest)) continue;
            this.deleteFile(manifest.path());
        }
    }

    @Override
    protected boolean cleanupAfterCommit() {
        return !this.rewrittenAppendManifests.isEmpty();
    }

    private List<ManifestFile> writeNewManifests() throws IOException {
        if (this.hasNewFiles && this.newManifests != null) {
            this.newManifests.forEach(file -> this.deleteFile(file.path()));
            this.newManifests = null;
        }
        if (this.newManifests == null && !this.newFiles.isEmpty()) {
            this.newManifests = this.writeDataManifests((Collection<DataFile>)this.newFiles, this.spec);
            this.hasNewFiles = false;
        }
        return this.newManifests;
    }
}

