/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import java.util.Set;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.UpdateRequirement;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.view.ViewMetadata;

public class UpdateRequirements {
    private UpdateRequirements() {
    }

    public static List<UpdateRequirement> forCreateTable(List<MetadataUpdate> metadataUpdates) {
        Preconditions.checkArgument((null != metadataUpdates ? 1 : 0) != 0, (Object)"Invalid metadata updates: null");
        Builder builder = new Builder(null, false);
        builder.require(new UpdateRequirement.AssertTableDoesNotExist());
        metadataUpdates.forEach(x$0 -> builder.update((MetadataUpdate)x$0));
        return builder.build();
    }

    public static List<UpdateRequirement> forReplaceTable(TableMetadata base, List<MetadataUpdate> metadataUpdates) {
        Preconditions.checkArgument((null != base ? 1 : 0) != 0, (Object)"Invalid table metadata: null");
        Preconditions.checkArgument((null != metadataUpdates ? 1 : 0) != 0, (Object)"Invalid metadata updates: null");
        Builder builder = new Builder(base, true);
        builder.require(new UpdateRequirement.AssertTableUUID(base.uuid()));
        metadataUpdates.forEach(x$0 -> builder.update((MetadataUpdate)x$0));
        return builder.build();
    }

    public static List<UpdateRequirement> forUpdateTable(TableMetadata base, List<MetadataUpdate> metadataUpdates) {
        Preconditions.checkArgument((null != base ? 1 : 0) != 0, (Object)"Invalid table metadata: null");
        Preconditions.checkArgument((null != metadataUpdates ? 1 : 0) != 0, (Object)"Invalid metadata updates: null");
        Builder builder = new Builder(base, false);
        builder.require(new UpdateRequirement.AssertTableUUID(base.uuid()));
        metadataUpdates.forEach(x$0 -> builder.update((MetadataUpdate)x$0));
        return builder.build();
    }

    public static List<UpdateRequirement> forReplaceView(ViewMetadata base, List<MetadataUpdate> metadataUpdates) {
        Preconditions.checkArgument((null != base ? 1 : 0) != 0, (Object)"Invalid view metadata: null");
        Preconditions.checkArgument((null != metadataUpdates ? 1 : 0) != 0, (Object)"Invalid metadata updates: null");
        Builder builder = new Builder(null, false);
        builder.require(new UpdateRequirement.AssertViewUUID(base.uuid()));
        metadataUpdates.forEach(x$0 -> builder.update((MetadataUpdate)x$0));
        return builder.build();
    }

    private static class Builder {
        private final TableMetadata base;
        private final ImmutableList.Builder<UpdateRequirement> requirements = ImmutableList.builder();
        private final Set<String> changedRefs = Sets.newHashSet();
        private final boolean isReplace;
        private boolean addedSchema = false;
        private boolean setSchemaId = false;
        private boolean addedSpec = false;
        private boolean setSpecId = false;
        private boolean setOrderId = false;

        private Builder(TableMetadata base, boolean isReplace) {
            this.base = base;
            this.isReplace = isReplace;
        }

        private Builder require(UpdateRequirement requirement) {
            Preconditions.checkArgument((requirement != null ? 1 : 0) != 0, (Object)"Invalid requirement: null");
            this.requirements.add((Object)requirement);
            return this;
        }

        private Builder update(MetadataUpdate update) {
            Preconditions.checkArgument((update != null ? 1 : 0) != 0, (Object)"Invalid update: null");
            if (update instanceof MetadataUpdate.SetSnapshotRef) {
                this.update((MetadataUpdate.SetSnapshotRef)update);
            } else if (update instanceof MetadataUpdate.AddSchema) {
                this.update((MetadataUpdate.AddSchema)update);
            } else if (update instanceof MetadataUpdate.SetCurrentSchema) {
                this.update((MetadataUpdate.SetCurrentSchema)update);
            } else if (update instanceof MetadataUpdate.AddPartitionSpec) {
                this.update((MetadataUpdate.AddPartitionSpec)update);
            } else if (update instanceof MetadataUpdate.SetDefaultPartitionSpec) {
                this.update((MetadataUpdate.SetDefaultPartitionSpec)update);
            } else if (update instanceof MetadataUpdate.SetDefaultSortOrder) {
                this.update((MetadataUpdate.SetDefaultSortOrder)update);
            }
            return this;
        }

        private void update(MetadataUpdate.SetSnapshotRef setRef) {
            String name = setRef.name();
            boolean added = this.changedRefs.add(name);
            if (added && this.base != null && !this.isReplace) {
                SnapshotRef baseRef = this.base.ref(name);
                this.require(new UpdateRequirement.AssertRefSnapshotID(name, baseRef != null ? Long.valueOf(baseRef.snapshotId()) : null));
            }
        }

        private void update(MetadataUpdate.AddSchema unused) {
            if (!this.addedSchema) {
                if (this.base != null) {
                    this.require(new UpdateRequirement.AssertLastAssignedFieldId(this.base.lastColumnId()));
                }
                this.addedSchema = true;
            }
        }

        private void update(MetadataUpdate.SetCurrentSchema unused) {
            if (!this.setSchemaId) {
                if (this.base != null && !this.isReplace) {
                    this.require(new UpdateRequirement.AssertCurrentSchemaID(this.base.currentSchemaId()));
                }
                this.setSchemaId = true;
            }
        }

        private void update(MetadataUpdate.AddPartitionSpec unused) {
            if (!this.addedSpec) {
                if (this.base != null) {
                    this.require(new UpdateRequirement.AssertLastAssignedPartitionId(this.base.lastAssignedPartitionId()));
                }
                this.addedSpec = true;
            }
        }

        private void update(MetadataUpdate.SetDefaultPartitionSpec unused) {
            if (!this.setSpecId) {
                if (this.base != null && !this.isReplace) {
                    this.require(new UpdateRequirement.AssertDefaultSpecID(this.base.defaultSpecId()));
                }
                this.setSpecId = true;
            }
        }

        private void update(MetadataUpdate.SetDefaultSortOrder unused) {
            if (!this.setOrderId) {
                if (this.base != null && !this.isReplace) {
                    this.require(new UpdateRequirement.AssertDefaultSortOrderID(this.base.defaultSortOrderId()));
                }
                this.setOrderId = true;
            }
        }

        private List<UpdateRequirement> build() {
            return this.requirements.build();
        }
    }
}

