/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.Serializable;
import java.util.List;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.Types;

public abstract class SupportsIndexProjection
implements StructLike,
Serializable {
    private final int[] fromProjectionPos;

    protected SupportsIndexProjection(int size) {
        this.fromProjectionPos = new int[size];
        for (int i = 0; i < this.fromProjectionPos.length; ++i) {
            this.fromProjectionPos[i] = i;
        }
    }

    protected SupportsIndexProjection(Types.StructType baseType, Types.StructType projectionType) {
        List allFields = baseType.fields();
        List fields = projectionType.fields();
        this.fromProjectionPos = new int[fields.size()];
        for (int i = 0; i < this.fromProjectionPos.length; ++i) {
            boolean found = false;
            for (int j = 0; j < allFields.size(); ++j) {
                if (((Types.NestedField)fields.get(i)).fieldId() != ((Types.NestedField)allFields.get(j)).fieldId()) continue;
                found = true;
                this.fromProjectionPos[i] = j;
            }
            if (found) continue;
            throw new IllegalArgumentException("Cannot find projected field: " + fields.get(i));
        }
    }

    protected SupportsIndexProjection(SupportsIndexProjection toCopy) {
        this.fromProjectionPos = toCopy.fromProjectionPos;
    }

    protected abstract <T> T internalGet(int var1, Class<T> var2);

    protected abstract <T> void internalSet(int var1, T var2);

    private int pos(int basePos) {
        return this.fromProjectionPos[basePos];
    }

    public int size() {
        return this.fromProjectionPos.length;
    }

    public <T> T get(int basePos, Class<T> javaClass) {
        return this.internalGet(this.pos(basePos), javaClass);
    }

    public <T> void set(int basePos, T value) {
        this.internalSet(this.pos(basePos), value);
    }
}

