/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.avro;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.SchemaNormalization;
import org.apache.avro.message.BadHeaderException;
import org.apache.avro.message.MessageDecoder;
import org.apache.avro.message.MissingSchemaException;
import org.apache.avro.message.SchemaStore;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.avro.IcebergEncoder;
import org.apache.iceberg.data.avro.RawDecoder;
import org.apache.iceberg.relocated.com.google.common.collect.MapMaker;

public class IcebergDecoder<D>
extends MessageDecoder.BaseDecoder<D> {
    private static final ThreadLocal<byte[]> HEADER_BUFFER = ThreadLocal.withInitial(() -> new byte[10]);
    private static final ThreadLocal<ByteBuffer> FP_BUFFER = ThreadLocal.withInitial(() -> {
        byte[] header = HEADER_BUFFER.get();
        return ByteBuffer.wrap(header).order(ByteOrder.LITTLE_ENDIAN);
    });
    private final Schema readSchema;
    private final SchemaStore resolver;
    private final Map<Long, RawDecoder<D>> decoders = new MapMaker().makeMap();

    public IcebergDecoder(Schema readSchema) {
        this(readSchema, null);
    }

    public IcebergDecoder(Schema readSchema, SchemaStore resolver) {
        this.readSchema = readSchema;
        this.resolver = resolver;
        this.addSchema(this.readSchema);
    }

    public void addSchema(Schema writeSchema) {
        this.addSchema(AvroSchemaUtil.convert(writeSchema, "table"));
    }

    private void addSchema(org.apache.avro.Schema writeSchema) {
        long fp = SchemaNormalization.parsingFingerprint64((org.apache.avro.Schema)writeSchema);
        RawDecoder decoder = new RawDecoder(this.readSchema, avroSchema -> DataReader.create(this.readSchema, avroSchema), writeSchema);
        this.decoders.put(fp, decoder);
    }

    private RawDecoder<D> getDecoder(long fp) {
        org.apache.avro.Schema writeSchema;
        RawDecoder<D> decoder = this.decoders.get(fp);
        if (decoder != null) {
            return decoder;
        }
        if (this.resolver != null && (writeSchema = this.resolver.findByFingerprint(fp)) != null) {
            this.addSchema(writeSchema);
            return this.decoders.get(fp);
        }
        throw new MissingSchemaException("Cannot resolve schema for fingerprint: " + fp);
    }

    public D decode(InputStream stream, D reuse) throws IOException {
        byte[] header = HEADER_BUFFER.get();
        try {
            if (!this.readFully(stream, header)) {
                throw new BadHeaderException("Not enough header bytes");
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to read header and fingerprint bytes", e);
        }
        if (IcebergEncoder.V1_HEADER[0] != header[0] || IcebergEncoder.V1_HEADER[1] != header[1]) {
            throw new BadHeaderException(String.format(Locale.ROOT, "Unrecognized header bytes: 0x%02X 0x%02X", header[0], header[1]));
        }
        RawDecoder<D> decoder = this.getDecoder(FP_BUFFER.get().getLong(2));
        try {
            return decoder.decode(stream, reuse);
        }
        catch (UncheckedIOException e) {
            throw new AvroRuntimeException((Throwable)e);
        }
    }

    private boolean readFully(InputStream stream, byte[] bytes) throws IOException {
        int bytesRead;
        int pos = 0;
        while (bytes.length - pos > 0 && (bytesRead = stream.read(bytes, pos, bytes.length - pos)) > 0) {
            pos += bytesRead;
        }
        return pos == bytes.length;
    }
}

