/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.deletes;

import java.util.Collection;
import java.util.List;
import java.util.function.LongConsumer;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.deletes.PositionDeleteIndex;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.roaringbitmap.longlong.Roaring64Bitmap;

class BitmapPositionDeleteIndex
implements PositionDeleteIndex {
    private final Roaring64Bitmap roaring64Bitmap = new Roaring64Bitmap();
    private final List<DeleteFile> deleteFiles;

    BitmapPositionDeleteIndex() {
        this.deleteFiles = Lists.newArrayList();
    }

    BitmapPositionDeleteIndex(Collection<DeleteFile> deleteFiles) {
        this.deleteFiles = Lists.newArrayList(deleteFiles);
    }

    BitmapPositionDeleteIndex(DeleteFile deleteFile) {
        this.deleteFiles = deleteFile != null ? Lists.newArrayList((Object[])new DeleteFile[]{deleteFile}) : Lists.newArrayList();
    }

    void merge(BitmapPositionDeleteIndex that) {
        this.roaring64Bitmap.or(that.roaring64Bitmap);
        this.deleteFiles.addAll(that.deleteFiles);
    }

    @Override
    public void delete(long position) {
        this.roaring64Bitmap.add(new long[]{position});
    }

    @Override
    public void delete(long posStart, long posEnd) {
        this.roaring64Bitmap.addRange(posStart, posEnd);
    }

    @Override
    public void merge(PositionDeleteIndex that) {
        if (that instanceof BitmapPositionDeleteIndex) {
            this.merge((BitmapPositionDeleteIndex)that);
        } else {
            that.forEach(this::delete);
            this.deleteFiles.addAll(that.deleteFiles());
        }
    }

    @Override
    public boolean isDeleted(long position) {
        return this.roaring64Bitmap.contains(position);
    }

    @Override
    public boolean isEmpty() {
        return this.roaring64Bitmap.isEmpty();
    }

    @Override
    public void forEach(LongConsumer consumer) {
        this.roaring64Bitmap.forEach(consumer::accept);
    }

    @Override
    public Collection<DeleteFile> deleteFiles() {
        return this.deleteFiles;
    }
}

