/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.hadoop.HadoopConfigurable;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.hadoop.SerializableConfiguration;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.DelegateFileIO;
import org.apache.iceberg.io.FileInfo;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.util.SerializableMap;
import org.apache.iceberg.util.SerializableSupplier;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFileIO
implements HadoopConfigurable,
DelegateFileIO {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopFileIO.class);
    private static final String DELETE_FILE_PARALLELISM = "iceberg.hadoop.delete-file-parallelism";
    private static final String DELETE_FILE_POOL_NAME = "iceberg-hadoopfileio-delete";
    private static final int DELETE_RETRY_ATTEMPTS = 3;
    private static final int DEFAULT_DELETE_CORE_MULTIPLE = 4;
    private static volatile ExecutorService executorService;
    private SerializableSupplier<Configuration> hadoopConf;
    private SerializableMap<String, String> properties = SerializableMap.copyOf(ImmutableMap.of());

    public HadoopFileIO() {
    }

    public HadoopFileIO(Configuration hadoopConf) {
        this(new SerializableConfiguration(hadoopConf)::get);
    }

    public HadoopFileIO(SerializableSupplier<Configuration> hadoopConf) {
        this.hadoopConf = hadoopConf;
    }

    public Configuration conf() {
        return this.getConf();
    }

    public void initialize(Map<String, String> props) {
        this.properties = SerializableMap.copyOf(props);
    }

    public InputFile newInputFile(String path) {
        return HadoopInputFile.fromLocation((CharSequence)path, this.getConf());
    }

    public InputFile newInputFile(String path, long length) {
        return HadoopInputFile.fromLocation((CharSequence)path, length, this.getConf());
    }

    public OutputFile newOutputFile(String path) {
        return HadoopOutputFile.fromPath(new Path(path), this.getConf());
    }

    public void deleteFile(String path) {
        Path toDelete = new Path(path);
        FileSystem fs = Util.getFs(toDelete, this.getConf());
        try {
            fs.delete(toDelete, false);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to delete file: %s", new Object[]{path});
        }
    }

    public Map<String, String> properties() {
        return this.properties.immutableMap();
    }

    public void setConf(Configuration conf) {
        this.hadoopConf = new SerializableConfiguration(conf)::get;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConf() {
        if (this.hadoopConf == null) {
            HadoopFileIO hadoopFileIO = this;
            synchronized (hadoopFileIO) {
                if (this.hadoopConf == null) {
                    this.hadoopConf = new SerializableConfiguration(new Configuration())::get;
                }
            }
        }
        return (Configuration)this.hadoopConf.get();
    }

    @Override
    public void serializeConfWith(Function<Configuration, SerializableSupplier<Configuration>> confSerializer) {
        this.hadoopConf = confSerializer.apply(this.getConf());
    }

    public Iterable<FileInfo> listPrefix(String prefix) {
        Path prefixToList = new Path(prefix);
        FileSystem fs = Util.getFs(prefixToList, this.getConf());
        return () -> {
            try {
                return Streams.stream(new AdaptingIterator(fs.listFiles(prefixToList, true))).map(fileStatus -> new FileInfo(fileStatus.getPath().toString(), fileStatus.getLen(), fileStatus.getModificationTime())).iterator();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public void deletePrefix(String prefix) {
        Path prefixToDelete = new Path(prefix);
        FileSystem fs = Util.getFs(prefixToDelete, this.getConf());
        try {
            fs.delete(prefixToDelete, true);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void deleteFiles(Iterable<String> pathsToDelete) throws BulkDeletionFailureException {
        AtomicInteger failureCount = new AtomicInteger(0);
        Tasks.foreach(pathsToDelete).executeWith(this.executorService()).retry(3).stopRetryOn(FileNotFoundException.class).suppressFailureWhenFinished().onFailure((f, e) -> {
            LOG.error("Failure during bulk delete on file: {} ", f, (Object)e);
            failureCount.incrementAndGet();
        }).run(this::deleteFile);
        if (failureCount.get() != 0) {
            throw new BulkDeletionFailureException(failureCount.get());
        }
    }

    private int deleteThreads() {
        int defaultValue = Runtime.getRuntime().availableProcessors() * 4;
        return this.conf().getInt(DELETE_FILE_PARALLELISM, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutorService executorService() {
        if (executorService != null) return executorService;
        Class<HadoopFileIO> clazz = HadoopFileIO.class;
        synchronized (HadoopFileIO.class) {
            if (executorService != null) return executorService;
            executorService = ThreadPools.newExitingWorkerPool(DELETE_FILE_POOL_NAME, this.deleteThreads());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return executorService;
        }
    }

    private static class AdaptingIterator<E>
    implements Iterator<E>,
    RemoteIterator<E> {
        private final RemoteIterator<E> delegate;

        AdaptingIterator(RemoteIterator<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.delegate.hasNext();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public E next() {
            try {
                return (E)this.delegate.next();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

