/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.util.Collections;
import java.util.List;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.util.CharSequenceSet;

public class DeleteWriteResult {
    private final List<DeleteFile> deleteFiles;
    private final CharSequenceSet referencedDataFiles;
    private final List<DeleteFile> rewrittenDeleteFiles;

    public DeleteWriteResult(DeleteFile deleteFile) {
        this.deleteFiles = Collections.singletonList(deleteFile);
        this.referencedDataFiles = CharSequenceSet.empty();
        this.rewrittenDeleteFiles = Collections.emptyList();
    }

    public DeleteWriteResult(DeleteFile deleteFile, CharSequenceSet referencedDataFiles) {
        this.deleteFiles = Collections.singletonList(deleteFile);
        this.referencedDataFiles = referencedDataFiles;
        this.rewrittenDeleteFiles = Collections.emptyList();
    }

    public DeleteWriteResult(List<DeleteFile> deleteFiles) {
        this.deleteFiles = deleteFiles;
        this.referencedDataFiles = CharSequenceSet.empty();
        this.rewrittenDeleteFiles = Collections.emptyList();
    }

    public DeleteWriteResult(List<DeleteFile> deleteFiles, CharSequenceSet referencedDataFiles) {
        this.deleteFiles = deleteFiles;
        this.referencedDataFiles = referencedDataFiles;
        this.rewrittenDeleteFiles = Collections.emptyList();
    }

    public DeleteWriteResult(List<DeleteFile> deleteFiles, CharSequenceSet referencedDataFiles, List<DeleteFile> rewrittenDeleteFiles) {
        this.deleteFiles = deleteFiles;
        this.referencedDataFiles = referencedDataFiles;
        this.rewrittenDeleteFiles = rewrittenDeleteFiles;
    }

    public List<DeleteFile> deleteFiles() {
        return this.deleteFiles;
    }

    public CharSequenceSet referencedDataFiles() {
        return this.referencedDataFiles;
    }

    public boolean referencesDataFiles() {
        return this.referencedDataFiles != null && !this.referencedDataFiles.isEmpty();
    }

    public List<DeleteFile> rewrittenDeleteFiles() {
        return this.rewrittenDeleteFiles;
    }
}

