/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hadoop.HadoopConfigurable;
import org.apache.iceberg.hadoop.SerializableConfiguration;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.DelegateFileIO;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileInfo;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.SerializableMap;
import org.apache.iceberg.util.SerializableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolvingFileIO
implements HadoopConfigurable,
DelegateFileIO {
    private static final Logger LOG = LoggerFactory.getLogger(ResolvingFileIO.class);
    private static final int BATCH_SIZE = 100000;
    private static final String FALLBACK_IMPL = "org.apache.iceberg.hadoop.HadoopFileIO";
    private static final String S3_FILE_IO_IMPL = "org.apache.iceberg.aws.s3.S3FileIO";
    private static final String GCS_FILE_IO_IMPL = "org.apache.iceberg.gcp.gcs.GCSFileIO";
    private static final String ADLS_FILE_IO_IMPL = "org.apache.iceberg.azure.adlsv2.ADLSFileIO";
    private static final Map<String, String> SCHEME_TO_FILE_IO = ImmutableMap.of((Object)"s3", (Object)"org.apache.iceberg.aws.s3.S3FileIO", (Object)"s3a", (Object)"org.apache.iceberg.aws.s3.S3FileIO", (Object)"s3n", (Object)"org.apache.iceberg.aws.s3.S3FileIO", (Object)"gs", (Object)"org.apache.iceberg.gcp.gcs.GCSFileIO", (Object)"abfs", (Object)"org.apache.iceberg.azure.adlsv2.ADLSFileIO", (Object)"abfss", (Object)"org.apache.iceberg.azure.adlsv2.ADLSFileIO", (Object)"wasb", (Object)"org.apache.iceberg.azure.adlsv2.ADLSFileIO", (Object)"wasbs", (Object)"org.apache.iceberg.azure.adlsv2.ADLSFileIO");
    private final Map<String, DelegateFileIO> ioInstances = Maps.newConcurrentMap();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final transient StackTraceElement[] createStack = Thread.currentThread().getStackTrace();
    private SerializableMap<String, String> properties;
    private SerializableSupplier<Configuration> hadoopConf;

    public InputFile newInputFile(String location) {
        return this.io(location).newInputFile(location);
    }

    public InputFile newInputFile(String location, long length) {
        return this.io(location).newInputFile(location, length);
    }

    public OutputFile newOutputFile(String location) {
        return this.io(location).newOutputFile(location);
    }

    public void deleteFile(String location) {
        this.io(location).deleteFile(location);
    }

    public void deleteFiles(Iterable<String> pathsToDelete) throws BulkDeletionFailureException {
        Iterators.partition(pathsToDelete.iterator(), (int)100000).forEachRemaining(partitioned -> {
            Map<DelegateFileIO, List<String>> pathByFileIO = partitioned.stream().collect(Collectors.groupingBy(this::io));
            for (Map.Entry<DelegateFileIO, List<String>> entries : pathByFileIO.entrySet()) {
                DelegateFileIO io = entries.getKey();
                List<String> filePaths = entries.getValue();
                io.deleteFiles(filePaths);
            }
        });
    }

    public Map<String, String> properties() {
        return this.properties.immutableMap();
    }

    public void initialize(Map<String, String> newProperties) {
        this.close();
        this.properties = SerializableMap.copyOf(newProperties);
        this.isClosed.set(false);
    }

    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            ArrayList instances = Lists.newArrayList();
            instances.addAll(this.ioInstances.values());
            this.ioInstances.clear();
            for (DelegateFileIO io : instances) {
                io.close();
            }
        }
    }

    @Override
    public void serializeConfWith(Function<Configuration, SerializableSupplier<Configuration>> confSerializer) {
        this.hadoopConf = confSerializer.apply(this.getConf());
    }

    public void setConf(Configuration conf) {
        this.hadoopConf = new SerializableConfiguration(conf)::get;
    }

    public Configuration getConf() {
        return Optional.ofNullable(this.hadoopConf).map(Supplier::get).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    DelegateFileIO io(String location) {
        String impl = this.implFromLocation(location);
        DelegateFileIO io = this.ioInstances.get(impl);
        if (io != null) {
            if (io instanceof HadoopConfigurable && ((HadoopConfigurable)io).getConf() == null) {
                DelegateFileIO delegateFileIO = io;
                synchronized (delegateFileIO) {
                    if (((HadoopConfigurable)io).getConf() == null) {
                        ((HadoopConfigurable)io).setConf(this.getConf());
                    }
                }
            }
            return io;
        }
        return this.ioInstances.computeIfAbsent(impl, key -> {
            FileIO fileIO;
            Configuration conf = this.getConf();
            try {
                HashMap props = Maps.newHashMap(this.properties);
                props.put("init-creation-stacktrace", "false");
                fileIO = CatalogUtil.loadFileIO(key, props, conf);
            }
            catch (IllegalArgumentException e) {
                if (key.equals(FALLBACK_IMPL)) {
                    throw e;
                }
                LOG.warn("Failed to load FileIO implementation: {}, falling back to {}", new Object[]{key, FALLBACK_IMPL, e});
                try {
                    fileIO = CatalogUtil.loadFileIO(FALLBACK_IMPL, this.properties, conf);
                }
                catch (IllegalArgumentException suppressed) {
                    LOG.warn("Failed to load FileIO implementation: {} (fallback)", (Object)FALLBACK_IMPL, (Object)suppressed);
                    e.addSuppressed(suppressed);
                    throw e;
                }
            }
            Preconditions.checkState((boolean)(fileIO instanceof DelegateFileIO), (Object)("FileIO does not implement DelegateFileIO: " + fileIO.getClass().getName()));
            return (DelegateFileIO)fileIO;
        });
    }

    @VisibleForTesting
    String implFromLocation(String location) {
        return SCHEME_TO_FILE_IO.getOrDefault(ResolvingFileIO.scheme(location), FALLBACK_IMPL);
    }

    public Class<?> ioClass(String location) {
        String fileIOClassName = this.implFromLocation(location);
        try {
            return Class.forName(fileIOClassName);
        }
        catch (ClassNotFoundException e) {
            throw new ValidationException("Class %s not found : %s", new Object[]{fileIOClassName, e.getMessage()});
        }
    }

    private static String scheme(String location) {
        int colonPos = location.indexOf(":");
        if (colonPos > 0) {
            return location.substring(0, colonPos);
        }
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isClosed.get()) {
            this.close();
            if (null != this.createStack) {
                String trace = Joiner.on((String)"\n\t").join((Object[])Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
                LOG.warn("Unclosed ResolvingFileIO instance created by:\n\t{}", (Object)trace);
            }
        }
    }

    public Iterable<FileInfo> listPrefix(String prefix) {
        return this.io(prefix).listPrefix(prefix);
    }

    public void deletePrefix(String prefix) {
        this.io(prefix).deletePrefix(prefix);
    }
}

