/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.BaseTransaction;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateRequirement;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.ViewCatalog;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ImmutableLoadViewResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.view.BaseView;
import org.apache.iceberg.view.SQLViewRepresentation;
import org.apache.iceberg.view.View;
import org.apache.iceberg.view.ViewBuilder;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewOperations;
import org.apache.iceberg.view.ViewRepresentation;

public class CatalogHandlers {
    private static final Schema EMPTY_SCHEMA = new Schema(new Types.NestedField[0]);
    private static final String INITIAL_PAGE_TOKEN = "";

    private CatalogHandlers() {
    }

    private static <T> Pair<List<T>, String> paginate(List<T> list, String pageToken, int pageSize) {
        int pageStart;
        int n = pageStart = INITIAL_PAGE_TOKEN.equals(pageToken) ? 0 : Integer.parseInt(pageToken);
        if (pageStart >= list.size()) {
            return Pair.of(Collections.emptyList(), null);
        }
        int end = Math.min(pageStart + pageSize, list.size());
        List<T> subList = list.subList(pageStart, end);
        String nextPageToken = end >= list.size() ? null : String.valueOf(end);
        return Pair.of(subList, nextPageToken);
    }

    public static ListNamespacesResponse listNamespaces(SupportsNamespaces catalog, Namespace parent) {
        List results = parent.isEmpty() ? catalog.listNamespaces() : catalog.listNamespaces(parent);
        return ListNamespacesResponse.builder().addAll(results).build();
    }

    public static ListNamespacesResponse listNamespaces(SupportsNamespaces catalog, Namespace parent, String pageToken, String pageSize) {
        List results = parent.isEmpty() ? catalog.listNamespaces() : catalog.listNamespaces(parent);
        Pair page = CatalogHandlers.paginate(results, pageToken, Integer.parseInt(pageSize));
        return ListNamespacesResponse.builder().addAll(page.first()).nextPageToken(page.second()).build();
    }

    public static CreateNamespaceResponse createNamespace(SupportsNamespaces catalog, CreateNamespaceRequest request) {
        Namespace namespace = request.namespace();
        catalog.createNamespace(namespace, request.properties());
        return CreateNamespaceResponse.builder().withNamespace(namespace).setProperties(catalog.loadNamespaceMetadata(namespace)).build();
    }

    public static GetNamespaceResponse loadNamespace(SupportsNamespaces catalog, Namespace namespace) {
        Map properties = catalog.loadNamespaceMetadata(namespace);
        return GetNamespaceResponse.builder().withNamespace(namespace).setProperties(properties).build();
    }

    public static void dropNamespace(SupportsNamespaces catalog, Namespace namespace) {
        boolean dropped = catalog.dropNamespace(namespace);
        if (!dropped) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
    }

    public static UpdateNamespacePropertiesResponse updateNamespaceProperties(SupportsNamespaces catalog, Namespace namespace, UpdateNamespacePropertiesRequest request) {
        request.validate();
        HashSet removals = Sets.newHashSet(request.removals());
        Map<String, String> updates = request.updates();
        Map startProperties = catalog.loadNamespaceMetadata(namespace);
        Sets.SetView missing = Sets.difference((Set)removals, startProperties.keySet());
        if (!updates.isEmpty()) {
            catalog.setProperties(namespace, updates);
        }
        if (!removals.isEmpty()) {
            catalog.removeProperties(namespace, (Set)removals);
        }
        return UpdateNamespacePropertiesResponse.builder().addMissing((Collection<String>)missing).addUpdated(updates.keySet()).addRemoved((Collection<String>)Sets.difference((Set)removals, (Set)missing)).build();
    }

    public static ListTablesResponse listTables(Catalog catalog, Namespace namespace) {
        List idents = catalog.listTables(namespace);
        return ListTablesResponse.builder().addAll(idents).build();
    }

    public static ListTablesResponse listTables(Catalog catalog, Namespace namespace, String pageToken, String pageSize) {
        List results = catalog.listTables(namespace);
        Pair page = CatalogHandlers.paginate(results, pageToken, Integer.parseInt(pageSize));
        return ListTablesResponse.builder().addAll(page.first()).nextPageToken(page.second()).build();
    }

    public static LoadTableResponse stageTableCreate(Catalog catalog, Namespace namespace, CreateTableRequest request) {
        request.validate();
        TableIdentifier ident = TableIdentifier.of((Namespace)namespace, (String)request.name());
        if (catalog.tableExists(ident)) {
            throw new AlreadyExistsException("Table already exists: %s", new Object[]{ident});
        }
        HashMap properties = Maps.newHashMap();
        properties.put("created-at", OffsetDateTime.now(ZoneOffset.UTC).toString());
        properties.putAll(request.properties());
        String location = request.location() != null ? request.location() : catalog.buildTable(ident, request.schema()).withPartitionSpec(request.spec()).withSortOrder(request.writeOrder()).withProperties((Map)properties).createTransaction().table().location();
        TableMetadata metadata = TableMetadata.newTableMetadata(request.schema(), request.spec() != null ? request.spec() : PartitionSpec.unpartitioned(), request.writeOrder() != null ? request.writeOrder() : SortOrder.unsorted(), location, properties);
        return LoadTableResponse.builder().withTableMetadata(metadata).build();
    }

    public static LoadTableResponse createTable(Catalog catalog, Namespace namespace, CreateTableRequest request) {
        request.validate();
        TableIdentifier ident = TableIdentifier.of((Namespace)namespace, (String)request.name());
        Table table = catalog.buildTable(ident, request.schema()).withLocation(request.location()).withPartitionSpec(request.spec()).withSortOrder(request.writeOrder()).withProperties(request.properties()).create();
        if (table instanceof BaseTable) {
            return LoadTableResponse.builder().withTableMetadata(((BaseTable)table).operations().current()).build();
        }
        throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTable");
    }

    public static LoadTableResponse registerTable(Catalog catalog, Namespace namespace, RegisterTableRequest request) {
        request.validate();
        TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)request.name());
        Table table = catalog.registerTable(identifier, request.metadataLocation());
        if (table instanceof BaseTable) {
            return LoadTableResponse.builder().withTableMetadata(((BaseTable)table).operations().current()).build();
        }
        throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTable");
    }

    public static void dropTable(Catalog catalog, TableIdentifier ident) {
        boolean dropped = catalog.dropTable(ident, false);
        if (!dropped) {
            throw new NoSuchTableException("Table does not exist: %s", new Object[]{ident});
        }
    }

    public static void purgeTable(Catalog catalog, TableIdentifier ident) {
        boolean dropped = catalog.dropTable(ident, true);
        if (!dropped) {
            throw new NoSuchTableException("Table does not exist: %s", new Object[]{ident});
        }
    }

    public static LoadTableResponse loadTable(Catalog catalog, TableIdentifier ident) {
        Table table = catalog.loadTable(ident);
        if (table instanceof BaseTable) {
            return LoadTableResponse.builder().withTableMetadata(((BaseTable)table).operations().current()).build();
        }
        if (table instanceof BaseMetadataTable) {
            throw new NoSuchTableException("Table does not exist: %s", new Object[]{ident.toString()});
        }
        throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTable");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoadTableResponse updateTable(Catalog catalog, TableIdentifier ident, UpdateTableRequest request) {
        TableMetadata finalMetadata;
        if (CatalogHandlers.isCreate(request)) {
            Transaction transaction = catalog.buildTable(ident, EMPTY_SCHEMA).createOrReplaceTransaction();
            if (!(transaction instanceof BaseTransaction)) throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTransaction");
            BaseTransaction baseTransaction = (BaseTransaction)transaction;
            finalMetadata = CatalogHandlers.create(baseTransaction.underlyingOps(), request);
            return LoadTableResponse.builder().withTableMetadata(finalMetadata).build();
        } else {
            Table table = catalog.loadTable(ident);
            if (!(table instanceof BaseTable)) throw new IllegalStateException("Cannot wrap catalog that does not produce BaseTable");
            TableOperations ops = ((BaseTable)table).operations();
            finalMetadata = CatalogHandlers.commit(ops, request);
        }
        return LoadTableResponse.builder().withTableMetadata(finalMetadata).build();
    }

    public static void renameTable(Catalog catalog, RenameTableRequest request) {
        catalog.renameTable(request.source(), request.destination());
    }

    private static boolean isCreate(UpdateTableRequest request) {
        boolean isCreate = request.requirements().stream().anyMatch(UpdateRequirement.AssertTableDoesNotExist.class::isInstance);
        if (isCreate) {
            List invalidRequirements = request.requirements().stream().filter(req -> !(req instanceof UpdateRequirement.AssertTableDoesNotExist)).collect(Collectors.toList());
            Preconditions.checkArgument((boolean)invalidRequirements.isEmpty(), (String)"Invalid create requirements: %s", invalidRequirements);
        }
        return isCreate;
    }

    private static TableMetadata create(TableOperations ops, UpdateTableRequest request) {
        request.requirements().forEach(requirement -> requirement.validate(ops.current()));
        Optional<Integer> formatVersion = request.updates().stream().filter(update -> update instanceof MetadataUpdate.UpgradeFormatVersion).map(update -> ((MetadataUpdate.UpgradeFormatVersion)update).formatVersion()).findFirst();
        TableMetadata.Builder builder = formatVersion.map(TableMetadata::buildFromEmpty).orElseGet(TableMetadata::buildFromEmpty);
        request.updates().forEach(update -> update.applyTo(builder));
        ops.commit(null, builder.build());
        return ops.current();
    }

    static TableMetadata commit(TableOperations ops, UpdateTableRequest request) {
        AtomicBoolean isRetry = new AtomicBoolean(false);
        try {
            Tasks.foreach(ops).retry(4).exponentialBackoff(100L, 60000L, 1800000L, 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(taskOps -> {
                TableMetadata base = isRetry.get() ? taskOps.refresh() : taskOps.current();
                isRetry.set(true);
                try {
                    request.requirements().forEach(requirement -> requirement.validate(base));
                }
                catch (CommitFailedException e) {
                    throw new ValidationFailureException(e);
                }
                TableMetadata.Builder metadataBuilder = TableMetadata.buildFrom(base);
                request.updates().forEach(update -> update.applyTo(metadataBuilder));
                TableMetadata updated = metadataBuilder.build();
                if (updated.changes().isEmpty()) {
                    return;
                }
                taskOps.commit(base, updated);
            });
        }
        catch (ValidationFailureException e) {
            throw e.wrapped();
        }
        return ops.current();
    }

    private static BaseView asBaseView(View view) {
        Preconditions.checkState((boolean)(view instanceof BaseView), (Object)"Cannot wrap catalog that does not produce BaseView");
        return (BaseView)view;
    }

    public static ListTablesResponse listViews(ViewCatalog catalog, Namespace namespace) {
        return ListTablesResponse.builder().addAll(catalog.listViews(namespace)).build();
    }

    public static ListTablesResponse listViews(ViewCatalog catalog, Namespace namespace, String pageToken, String pageSize) {
        List results = catalog.listViews(namespace);
        Pair page = CatalogHandlers.paginate(results, pageToken, Integer.parseInt(pageSize));
        return ListTablesResponse.builder().addAll(page.first()).nextPageToken(page.second()).build();
    }

    public static LoadViewResponse createView(ViewCatalog catalog, Namespace namespace, CreateViewRequest request) {
        request.validate();
        ViewBuilder viewBuilder = ((ViewBuilder)((ViewBuilder)((ViewBuilder)catalog.buildView(TableIdentifier.of((Namespace)namespace, (String)request.name())).withSchema(request.schema())).withProperties(request.properties()).withDefaultNamespace(request.viewVersion().defaultNamespace())).withDefaultCatalog(request.viewVersion().defaultCatalog())).withLocation(request.location());
        Set unsupportedRepresentations = request.viewVersion().representations().stream().filter(r -> !(r instanceof SQLViewRepresentation)).map(ViewRepresentation::type).collect(Collectors.toSet());
        if (!unsupportedRepresentations.isEmpty()) {
            throw new IllegalStateException(String.format("Found unsupported view representations: %s", unsupportedRepresentations));
        }
        request.viewVersion().representations().stream().filter(SQLViewRepresentation.class::isInstance).map(SQLViewRepresentation.class::cast).forEach(r -> viewBuilder.withQuery(r.dialect(), r.sql()));
        View view = viewBuilder.create();
        return CatalogHandlers.viewResponse(view);
    }

    private static LoadViewResponse viewResponse(View view) {
        ViewMetadata metadata = CatalogHandlers.asBaseView(view).operations().current();
        return ImmutableLoadViewResponse.builder().metadata(metadata).metadataLocation(metadata.metadataFileLocation()).build();
    }

    public static LoadViewResponse loadView(ViewCatalog catalog, TableIdentifier viewIdentifier) {
        View view = catalog.loadView(viewIdentifier);
        return CatalogHandlers.viewResponse(view);
    }

    public static LoadViewResponse updateView(ViewCatalog catalog, TableIdentifier ident, UpdateTableRequest request) {
        View view = catalog.loadView(ident);
        ViewMetadata metadata = CatalogHandlers.commit(CatalogHandlers.asBaseView(view).operations(), request);
        return ImmutableLoadViewResponse.builder().metadata(metadata).metadataLocation(metadata.metadataFileLocation()).build();
    }

    public static void renameView(ViewCatalog catalog, RenameTableRequest request) {
        catalog.renameView(request.source(), request.destination());
    }

    public static void dropView(ViewCatalog catalog, TableIdentifier viewIdentifier) {
        boolean dropped = catalog.dropView(viewIdentifier);
        if (!dropped) {
            throw new NoSuchViewException("View does not exist: %s", new Object[]{viewIdentifier});
        }
    }

    static ViewMetadata commit(ViewOperations ops, UpdateTableRequest request) {
        AtomicBoolean isRetry = new AtomicBoolean(false);
        try {
            Tasks.foreach(ops).retry(4).exponentialBackoff(100L, 60000L, 1800000L, 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(taskOps -> {
                ViewMetadata base = isRetry.get() ? taskOps.refresh() : taskOps.current();
                isRetry.set(true);
                try {
                    request.requirements().forEach(requirement -> requirement.validate(base));
                }
                catch (CommitFailedException e) {
                    throw new ValidationFailureException(e);
                }
                ViewMetadata.Builder metadataBuilder = ViewMetadata.buildFrom(base);
                request.updates().forEach(update -> update.applyTo(metadataBuilder));
                ViewMetadata updated = metadataBuilder.build();
                if (updated.changes().isEmpty()) {
                    return;
                }
                taskOps.commit(base, updated);
            });
        }
        catch (ValidationFailureException e) {
            throw e.wrapped();
        }
        return ops.current();
    }

    private static class ValidationFailureException
    extends RuntimeException {
        private final CommitFailedException wrapped;

        private ValidationFailureException(CommitFailedException cause) {
            super(cause);
            this.wrapped = cause;
        }

        public CommitFailedException wrapped() {
            return this.wrapped;
        }
    }
}

