/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.util.Map;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.rest.RESTUtil;

public class ResourcePaths {
    private static final Joiner SLASH = Joiner.on((String)"/").skipNulls();
    private static final String PREFIX = "prefix";
    public static final String V1_NAMESPACES = "/v1/{prefix}/namespaces";
    public static final String V1_NAMESPACE = "/v1/{prefix}/namespaces/{namespace}";
    public static final String V1_NAMESPACE_PROPERTIES = "/v1/{prefix}/namespaces/{namespace}/properties";
    public static final String V1_TABLES = "/v1/{prefix}/namespaces/{namespace}/tables";
    public static final String V1_TABLE = "/v1/{prefix}/namespaces/{namespace}/tables/{table}";
    public static final String V1_TABLE_REGISTER = "/v1/{prefix}/namespaces/{namespace}/register";
    public static final String V1_TABLE_METRICS = "/v1/{prefix}/namespaces/{namespace}/tables/{table}/metrics";
    public static final String V1_TABLE_RENAME = "/v1/{prefix}/tables/rename";
    public static final String V1_TRANSACTIONS_COMMIT = "/v1/{prefix}/transactions/commit";
    public static final String V1_VIEWS = "/v1/{prefix}/namespaces/{namespace}/views";
    public static final String V1_VIEW = "/v1/{prefix}/namespaces/{namespace}/views/{view}";
    public static final String V1_VIEW_RENAME = "/v1/{prefix}/views/rename";
    private final String prefix;

    public static ResourcePaths forCatalogProperties(Map<String, String> properties) {
        return new ResourcePaths(properties.get(PREFIX));
    }

    public static String config() {
        return "v1/config";
    }

    public static String tokens() {
        return "v1/oauth/tokens";
    }

    public ResourcePaths(String prefix) {
        this.prefix = prefix;
    }

    public String namespaces() {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces"});
    }

    public String namespace(Namespace ns) {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces", RESTUtil.encodeNamespace(ns)});
    }

    public String namespaceProperties(Namespace ns) {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces", RESTUtil.encodeNamespace(ns), "properties"});
    }

    public String tables(Namespace ns) {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces", RESTUtil.encodeNamespace(ns), "tables"});
    }

    public String table(TableIdentifier ident) {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces", RESTUtil.encodeNamespace(ident.namespace()), "tables", RESTUtil.encodeString(ident.name())});
    }

    public String register(Namespace ns) {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces", RESTUtil.encodeNamespace(ns), "register"});
    }

    public String rename() {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"tables", "rename"});
    }

    public String metrics(TableIdentifier identifier) {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces", RESTUtil.encodeNamespace(identifier.namespace()), "tables", RESTUtil.encodeString(identifier.name()), "metrics"});
    }

    public String commitTransaction() {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"transactions", "commit"});
    }

    public String views(Namespace ns) {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces", RESTUtil.encodeNamespace(ns), "views"});
    }

    public String view(TableIdentifier ident) {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"namespaces", RESTUtil.encodeNamespace(ident.namespace()), "views", RESTUtil.encodeString(ident.name())});
    }

    public String renameView() {
        return SLASH.join((Object)"v1", (Object)this.prefix, new Object[]{"views", "rename"});
    }
}

