/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;

public class ContentFileUtil {
    private ContentFileUtil() {
    }

    public static <F extends ContentFile<K>, K> K copy(F file, boolean withStats, Set<Integer> requestedColumnIds) {
        if (withStats) {
            return (K)(requestedColumnIds != null ? file.copyWithStats(requestedColumnIds) : file.copy());
        }
        return (K)file.copyWithoutStats();
    }

    public static CharSequence referencedDataFile(DeleteFile deleteFile) {
        ByteBuffer upperPathBound;
        ByteBuffer lowerPathBound;
        if (deleteFile.content() == FileContent.EQUALITY_DELETES) {
            return null;
        }
        int pathId = MetadataColumns.DELETE_FILE_PATH.fieldId();
        Type pathType = MetadataColumns.DELETE_FILE_PATH.type();
        Map lowerBounds = deleteFile.lowerBounds();
        ByteBuffer byteBuffer = lowerPathBound = lowerBounds != null ? (ByteBuffer)lowerBounds.get(pathId) : null;
        if (lowerPathBound == null) {
            return null;
        }
        Map upperBounds = deleteFile.upperBounds();
        ByteBuffer byteBuffer2 = upperPathBound = upperBounds != null ? (ByteBuffer)upperBounds.get(pathId) : null;
        if (upperPathBound == null) {
            return null;
        }
        if (lowerPathBound.equals(upperPathBound)) {
            return (CharSequence)Conversions.fromByteBuffer((Type)pathType, (ByteBuffer)lowerPathBound);
        }
        return null;
    }

    public static String referencedDataFileLocation(DeleteFile deleteFile) {
        CharSequence location = ContentFileUtil.referencedDataFile(deleteFile);
        return location != null ? location.toString() : null;
    }
}

