/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.base.Preconditions;
import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Expression;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CoalesceExpression
extends Expression {
    private final List<Expression> operands;

    public CoalesceExpression(Expression first, Expression second, Expression ... additional) {
        this(Optional.empty(), (List<Expression>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(new Expression[]{first, second})).add(additional)).build()));
    }

    public CoalesceExpression(List<Expression> operands) {
        this(Optional.empty(), operands);
    }

    public CoalesceExpression(NodeLocation location, List<Expression> operands) {
        this(Optional.of(location), operands);
    }

    private CoalesceExpression(Optional<NodeLocation> location, List<Expression> operands) {
        super(location);
        Objects.requireNonNull(operands, "operands is null");
        Preconditions.checkArgument(operands.size() >= 2, "must have at least two operands");
        this.operands = ImmutableList.copyOf(operands);
    }

    public List<Expression> getOperands() {
        return this.operands;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCoalesceExpression(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.operands;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoalesceExpression that = (CoalesceExpression)o;
        return Objects.equals(this.operands, that.operands);
    }

    @Override
    public int hashCode() {
        return this.operands.hashCode();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return CoalesceExpression.sameClass(this, other);
    }
}

