/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.base.MoreObjects;
import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import com.linkedin.coral.$internal.io.trino.sql.tree.Relation;
import com.linkedin.coral.$internal.io.trino.sql.tree.SetOperation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Except
extends SetOperation {
    private final Relation left;
    private final Relation right;

    public Except(Relation left, Relation right, boolean distinct) {
        this(Optional.empty(), left, right, distinct);
    }

    public Except(NodeLocation location, Relation left, Relation right, boolean distinct) {
        this(Optional.of(location), left, right, distinct);
    }

    private Except(Optional<NodeLocation> location, Relation left, Relation right, boolean distinct) {
        super(location, distinct);
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        this.left = left;
        this.right = right;
    }

    public Relation getLeft() {
        return this.left;
    }

    public Relation getRight() {
        return this.right;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExcept(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.left, this.right);
    }

    @Override
    public List<Relation> getRelations() {
        return ImmutableList.of(this.left, this.right);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("left", this.left).add("right", this.right).add("distinct", this.isDistinct()).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Except o = (Except)obj;
        return Objects.equals(this.left, o.left) && Objects.equals(this.right, o.right) && Objects.equals(this.isDistinct(), o.isDistinct());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left, this.right, this.isDistinct());
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Except.sameClass(this, other)) {
            return false;
        }
        return this.isDistinct() == ((Except)other).isDistinct();
    }
}

