/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Expression;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import com.linkedin.coral.$internal.io.trino.sql.tree.WhenClause;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SearchedCaseExpression
extends Expression {
    private final List<WhenClause> whenClauses;
    private final Optional<Expression> defaultValue;

    public SearchedCaseExpression(List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
        this(Optional.empty(), whenClauses, defaultValue);
    }

    public SearchedCaseExpression(NodeLocation location, List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
        this(Optional.of(location), whenClauses, defaultValue);
    }

    private SearchedCaseExpression(Optional<NodeLocation> location, List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
        super(location);
        Objects.requireNonNull(whenClauses, "whenClauses is null");
        Objects.requireNonNull(defaultValue, "defaultValue is null");
        this.whenClauses = ImmutableList.copyOf(whenClauses);
        this.defaultValue = defaultValue;
    }

    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    public Optional<Expression> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSearchedCaseExpression(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.addAll(this.whenClauses);
        this.defaultValue.ifPresent(nodes::add);
        return nodes.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchedCaseExpression that = (SearchedCaseExpression)o;
        return Objects.equals(this.whenClauses, that.whenClauses) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.whenClauses, this.defaultValue);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return SearchedCaseExpression.sameClass(this, other);
    }
}

