/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Expression;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SubscriptExpression
extends Expression {
    private final Expression base;
    private final Expression index;

    public SubscriptExpression(Expression base, Expression index) {
        this(Optional.empty(), base, index);
    }

    public SubscriptExpression(NodeLocation location, Expression base, Expression index) {
        this(Optional.of(location), base, index);
    }

    private SubscriptExpression(Optional<NodeLocation> location, Expression base, Expression index) {
        super(location);
        this.base = Objects.requireNonNull(base, "base is null");
        this.index = Objects.requireNonNull(index, "index is null");
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSubscriptExpression(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.base, this.index);
    }

    public Expression getBase() {
        return this.base;
    }

    public Expression getIndex() {
        return this.index;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptExpression that = (SubscriptExpression)o;
        return Objects.equals(this.base, that.base) && Objects.equals(this.index, that.index);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.index);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return SubscriptExpression.sameClass(this, other);
    }
}

