/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.Date;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.Timestamp;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.TimestampTZ;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampTZUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampTZ.class);
    private static final LocalTime DEFAULT_LOCAL_TIME = LocalTime.of(0, 0);
    private static final Pattern SINGLE_DIGIT_PATTERN = Pattern.compile("[\\+-]\\d:\\d\\d");
    static final DateTimeFormatter FORMATTER;

    public static TimestampTZ parse(String s2) {
        return TimestampTZUtil.parse(s2, null);
    }

    public static TimestampTZ parse(String s2, ZoneId defaultTimeZone) {
        ZonedDateTime zonedDateTime;
        s2 = TimestampTZUtil.handleSingleDigitHourOffset(s2);
        try {
            zonedDateTime = ZonedDateTime.parse(s2, FORMATTER);
        }
        catch (DateTimeParseException e) {
            ZoneId zoneId;
            LocalTime localTime;
            TemporalAccessor accessor = FORMATTER.parse(s2);
            LocalDate localDate = LocalDate.from(accessor);
            try {
                localTime = LocalTime.from(accessor);
            }
            catch (DateTimeException e1) {
                localTime = DEFAULT_LOCAL_TIME;
            }
            try {
                zoneId = ZoneId.from(accessor);
            }
            catch (DateTimeException e2) {
                if (defaultTimeZone == null) {
                    throw new DateTimeException("Time Zone not available");
                }
                zoneId = defaultTimeZone;
            }
            zonedDateTime = ZonedDateTime.of(localDate, localTime, zoneId);
        }
        if (defaultTimeZone == null) {
            return new TimestampTZ(zonedDateTime);
        }
        return new TimestampTZ(zonedDateTime.withZoneSameInstant(defaultTimeZone));
    }

    private static String handleSingleDigitHourOffset(String s2) {
        Matcher matcher = SINGLE_DIGIT_PATTERN.matcher(s2);
        if (matcher.find()) {
            int index = matcher.start() + 1;
            s2 = s2.substring(0, index) + "0" + s2.substring(index, s2.length());
        }
        return s2;
    }

    public static TimestampTZ parseOrNull(String s2, ZoneId defaultTimeZone) {
        try {
            return TimestampTZUtil.parse(s2, defaultTimeZone);
        }
        catch (DateTimeParseException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invalid string " + s2 + " for TIMESTAMP WITH TIME ZONE", (Throwable)e);
            }
            return null;
        }
    }

    public static TimestampTZ convert(Date date, ZoneId defaultTimeZone) {
        return TimestampTZUtil.parse(date.toString(), defaultTimeZone);
    }

    public static TimestampTZ convert(Timestamp ts, ZoneId defaultTimeZone) {
        return TimestampTZUtil.parse(ts.toString(), defaultTimeZone);
    }

    public static ZoneId parseTimeZone(String timeZoneStr) {
        if (timeZoneStr == null || timeZoneStr.trim().isEmpty() || timeZoneStr.trim().toLowerCase().equals("local")) {
            return ZoneId.systemDefault();
        }
        try {
            return ZoneId.of(timeZoneStr);
        }
        catch (DateTimeException e1) {
            throw new RuntimeException("Invalid time zone displacement value", e1);
        }
    }

    public static Timestamp convertTimestampToZone(Timestamp ts, ZoneId fromZone, ZoneId toZone) {
        Instant instant = TimestampTZUtil.convert(ts, fromZone).getZonedDateTime().toInstant();
        LocalDateTime localDateTimeAtToZone = LocalDateTime.ofInstant(instant, toZone);
        return Timestamp.ofEpochSecond(localDateTimeAtToZone.toEpochSecond(ZoneOffset.UTC), localDateTimeAtToZone.getNano());
    }

    static {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.append(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        builder.optionalStart().appendLiteral(" ").append(DateTimeFormatter.ofPattern("HH:mm:ss")).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).optionalEnd().optionalEnd();
        builder.optionalStart().appendLiteral(" ").optionalEnd();
        builder.optionalStart().appendZoneText(TextStyle.NARROW).optionalEnd();
        FORMATTER = builder.toFormatter();
    }
}

