/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.metastore;

import com.codahale.metrics.Counter;
import com.linkedin.coral.;
import com.linkedin.coral.$internal.org.apache.hadoop.conf.Configuration;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import com.linkedin.coral.hive.metastore.api.MetaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMSMetricsListener
extends MetaStoreEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(HMSMetricsListener.class);
    private Counter createdDatabases = .Metrics.getOrCreateCounter((String)"create_total_count_dbs");
    private Counter deletedDatabases = .Metrics.getOrCreateCounter((String)"delete_total_count_dbs");
    private Counter createdTables = .Metrics.getOrCreateCounter((String)"create_total_count_tables");
    private Counter deletedTables = .Metrics.getOrCreateCounter((String)"delete_total_count_tables");
    private Counter createdParts = .Metrics.getOrCreateCounter((String)"create_total_count_partitions");
    private Counter deletedParts = .Metrics.getOrCreateCounter((String)"delete_total_count_partitions");

    public HMSMetricsListener(Configuration config) {
        super(config);
    }

    @Override
    public void onCreateDatabase(.CreateDatabaseEvent dbEvent) throws MetaException {
        .Metrics.getOrCreateGauge((String)"total_count_dbs").incrementAndGet();
        this.createdDatabases.inc();
    }

    @Override
    public void onDropDatabase(.DropDatabaseEvent dbEvent) throws MetaException {
        .Metrics.getOrCreateGauge((String)"total_count_dbs").decrementAndGet();
        this.deletedDatabases.inc();
    }

    @Override
    public void onCreateTable(.CreateTableEvent tableEvent) throws MetaException {
        .Metrics.getOrCreateGauge((String)"total_count_tables").incrementAndGet();
        this.createdTables.inc();
    }

    @Override
    public void onDropTable(.DropTableEvent tableEvent) throws MetaException {
        .Metrics.getOrCreateGauge((String)"total_count_tables").decrementAndGet();
        this.deletedTables.inc();
    }

    @Override
    public void onDropPartition(.DropPartitionEvent partitionEvent) throws MetaException {
        .Metrics.getOrCreateGauge((String)"total_count_partitions").decrementAndGet();
        this.deletedParts.inc();
    }

    @Override
    public void onAddPartition(.AddPartitionEvent partitionEvent) throws MetaException {
        .Metrics.getOrCreateGauge((String)"total_count_partitions").incrementAndGet();
        this.createdParts.inc();
    }
}

