/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyIntObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.io.IntWritable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hive.common.util.HiveStringUtils;

public class LazyInteger
extends LazyPrimitive<LazyIntObjectInspector, IntWritable> {
    public LazyInteger(LazyIntObjectInspector oi) {
        super(oi);
        this.data = new IntWritable();
    }

    public LazyInteger(LazyInteger copy) {
        super(copy);
        this.data = new IntWritable(((IntWritable)copy.data).get());
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        if (!LazyUtils.isNumberMaybe(bytes.getData(), start, length)) {
            this.isNull = true;
            return;
        }
        try {
            ((IntWritable)this.data).set(LazyInteger.parseInt(bytes.getData(), start, length, 10));
            this.isNull = false;
        }
        catch (NumberFormatException e) {
            this.isNull = true;
            this.logExceptionMessage(bytes, start, length, "INT");
        }
    }

    public static int parseInt(byte[] bytes, int start, int length) {
        return LazyInteger.parseInt(bytes, start, length, 10);
    }

    public static int parseInt(byte[] bytes, int start, int length, int radix) {
        return LazyInteger.parseInt(bytes, start, length, radix, false);
    }

    public static int parseInt(byte[] bytes, int start, int length, int radix, boolean trim) {
        boolean negative;
        if (bytes == null) {
            throw new NumberFormatException("String is null");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("Invalid radix: " + radix);
        }
        if (trim) {
            int leadingSpaces = HiveStringUtils.findLeadingSpaces((byte[])bytes, (int)start, (int)length);
            int trailingSpaces = HiveStringUtils.findTrailingSpaces((byte[])bytes, (int)start, (int)length);
            start += leadingSpaces;
            length -= Math.min(length, leadingSpaces + trailingSpaces);
        }
        if (length == 0) {
            throw new NumberFormatException("Empty string!");
        }
        int offset = start;
        boolean bl = negative = bytes[start] == 45;
        if (negative || bytes[start] == 43) {
            ++offset;
            if (length == 1) {
                throw new NumberFormatException(LazyUtils.convertToString(bytes, start, length));
            }
        }
        return LazyInteger.parse(bytes, start, length, offset, radix, negative);
    }

    private static int parse(byte[] bytes, int start, int length, int offset, int radix, boolean negative) {
        int digit;
        byte separator = 46;
        int max = Integer.MIN_VALUE / radix;
        int result = 0;
        int end = start + length;
        while (offset < end) {
            if ((digit = LazyUtils.digit(bytes[offset++], radix)) == -1) {
                if (bytes[offset - 1] == separator) break;
                throw new NumberFormatException(LazyUtils.convertToString(bytes, start, length));
            }
            if (max > result) {
                throw new NumberFormatException(LazyUtils.convertToString(bytes, start, length));
            }
            int next = result * radix - digit;
            if (next > result) {
                throw new NumberFormatException(LazyUtils.convertToString(bytes, start, length));
            }
            result = next;
        }
        while (offset < end) {
            if ((digit = LazyUtils.digit(bytes[offset++], radix)) != -1) continue;
            throw new NumberFormatException(LazyUtils.convertToString(bytes, start, length));
        }
        if (!negative && (result = -result) < 0) {
            throw new NumberFormatException(LazyUtils.convertToString(bytes, start, length));
        }
        return result;
    }

    public static void writeUTF8(OutputStream out, int i) throws IOException {
        boolean negative;
        if (i == 0) {
            out.write(48);
            return;
        }
        boolean bl = negative = i < 0;
        if (negative) {
            out.write(45);
        } else {
            i = -i;
        }
        int start = 1000000000;
        while (i / start == 0) {
            start /= 10;
        }
        while (start > 0) {
            out.write(48 - i / start % 10);
            start /= 10;
        }
    }

    public static void writeUTF8NoException(OutputStream out, int i) {
        try {
            LazyInteger.writeUTF8(out, i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

