/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.esri.core.geometry;

import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.ECoordinate;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.MathUtils;
import com.linkedin.coral.calcite.$internal.com.esri.core.geometry.NumberUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Comparator;

public final class Point2D
implements Serializable {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;

    public Point2D() {
    }

    public Point2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point2D(Point2D other) {
        this.setCoords(other);
    }

    public static Point2D construct(double x, double y) {
        return new Point2D(x, y);
    }

    public void setCoords(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setCoords(Point2D other) {
        this.x = other.x;
        this.y = other.y;
    }

    public boolean isEqual(Point2D other) {
        return this.x == other.x && this.y == other.y;
    }

    public boolean isEqual(double x_, double y_) {
        return this.x == x_ && this.y == y_;
    }

    public boolean isEqual(Point2D other, double tol) {
        return Math.abs(this.x - other.x) <= tol && Math.abs(this.y - other.y) <= tol;
    }

    public boolean equals(Point2D other) {
        return this.x == other.x && this.y == other.y;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Point2D)) {
            return false;
        }
        Point2D v = (Point2D)other;
        return this.x == v.x && this.y == v.y;
    }

    public void sub(Point2D other) {
        this.x -= other.x;
        this.y -= other.y;
    }

    public void sub(Point2D p1, Point2D p2) {
        this.x = p1.x - p2.x;
        this.y = p1.y - p2.y;
    }

    public void add(Point2D other) {
        this.x += other.x;
        this.y += other.y;
    }

    public void add(Point2D p1, Point2D p2) {
        this.x = p1.x + p2.x;
        this.y = p1.y + p2.y;
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public void negate(Point2D other) {
        this.x = -other.x;
        this.y = -other.y;
    }

    public void interpolate(Point2D other, double alpha) {
        MathUtils.lerp(this, other, alpha, this);
    }

    public void interpolate(Point2D p1, Point2D p2, double alpha) {
        MathUtils.lerp(p1, p2, alpha, this);
    }

    public void scaleAdd(double f, Point2D shift) {
        this.x = this.x * f + shift.x;
        this.y = this.y * f + shift.y;
    }

    public void scaleAdd(double f, Point2D other, Point2D shift) {
        this.x = other.x * f + shift.x;
        this.y = other.y * f + shift.y;
    }

    public void scale(double f, Point2D other) {
        this.x = f * other.x;
        this.y = f * other.y;
    }

    public void scale(double f) {
        this.x *= f;
        this.y *= f;
    }

    public int compare(Point2D other) {
        return this.y < other.y ? -1 : (this.y > other.y ? 1 : (this.x < other.x ? -1 : (this.x > other.x ? 1 : 0)));
    }

    int compareX(Point2D other) {
        return this.x < other.x ? -1 : (this.x > other.x ? 1 : (this.y < other.y ? -1 : (this.y > other.y ? 1 : 0)));
    }

    public void normalize(Point2D other) {
        double len = other.length();
        if (len == 0.0) {
            this.x = 1.0;
            this.y = 0.0;
        } else {
            this.x = other.x / len;
            this.y = other.y / len;
        }
    }

    public void normalize() {
        double len = this.length();
        if (len == 0.0) {
            this.x = 1.0;
            this.y = 0.0;
        }
        this.x /= len;
        this.y /= len;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double sqrLength() {
        return this.x * this.x + this.y * this.y;
    }

    public static double distance(Point2D pt1, Point2D pt2) {
        return Math.sqrt(Point2D.sqrDistance(pt1, pt2));
    }

    public double dotProduct(Point2D other) {
        return this.x * other.x + this.y * other.y;
    }

    double _dotProductAbs(Point2D other) {
        return Math.abs(this.x * other.x) + Math.abs(this.y * other.y);
    }

    public double crossProduct(Point2D other) {
        return this.x * other.y - this.y * other.x;
    }

    public void rotateDirect(double Cos, double Sin) {
        double xx = this.x * Cos - this.y * Sin;
        double yy = this.x * Sin + this.y * Cos;
        this.x = xx;
        this.y = yy;
    }

    public void rotateReverse(double Cos, double Sin) {
        double xx = this.x * Cos + this.y * Sin;
        double yy = -this.x * Sin + this.y * Cos;
        this.x = xx;
        this.y = yy;
    }

    public void leftPerpendicular() {
        double xx = this.x;
        this.x = -this.y;
        this.y = xx;
    }

    public void leftPerpendicular(Point2D pt) {
        this.x = -pt.y;
        this.y = pt.x;
    }

    public void rightPerpendicular() {
        double xx = this.x;
        this.x = this.y;
        this.y = -xx;
    }

    public void rightPerpendicular(Point2D pt) {
        this.x = pt.y;
        this.y = -pt.x;
    }

    void _setNan() {
        this.x = NumberUtils.NaN();
        this.y = NumberUtils.NaN();
    }

    boolean _isNan() {
        return NumberUtils.isNaN(this.x) || NumberUtils.isNaN(this.y);
    }

    final int _getQuarter() {
        if (this.x > 0.0) {
            if (this.y >= 0.0) {
                return 1;
            }
            return 4;
        }
        if (this.y > 0.0) {
            return 2;
        }
        return this.x == 0.0 ? 4 : 3;
    }

    public int getQuarter() {
        return this._getQuarter();
    }

    static final int _compareVectors(Point2D v1, Point2D v2) {
        int q1 = v1._getQuarter();
        int q2 = v2._getQuarter();
        if (q2 == q1) {
            double cross = v1.crossProduct(v2);
            return cross < 0.0 ? 1 : (cross > 0.0 ? -1 : 0);
        }
        return q1 < q2 ? -1 : 1;
    }

    public static int compareVectors(Point2D v1, Point2D v2) {
        return Point2D._compareVectors(v1, v2);
    }

    public static double sqrDistance(Point2D pt1, Point2D pt2) {
        double dx = pt1.x - pt2.x;
        double dy = pt1.y - pt2.y;
        return dx * dx + dy * dy;
    }

    public String toString() {
        return "(" + this.x + " , " + this.y + ")";
    }

    public void setNaN() {
        this.x = NumberUtils.NaN();
        this.y = NumberUtils.NaN();
    }

    public boolean isNaN() {
        return NumberUtils.isNaN(this.x) || NumberUtils.isNaN(this.y);
    }

    double _norm(int metric) {
        if (metric < 0 || this._isNan()) {
            return NumberUtils.NaN();
        }
        switch (metric) {
            case 0: {
                return Math.abs(this.x) >= Math.abs(this.y) ? Math.abs(this.x) : Math.abs(this.y);
            }
            case 1: {
                return Math.abs(this.x) + Math.abs(this.y);
            }
            case 2: {
                return Math.sqrt(this.x * this.x + this.y * this.y);
            }
        }
        return Math.pow(Math.pow(this.x, metric) + Math.pow(this.y, metric), 1.0 / (double)metric);
    }

    double offset(Point2D pt1, Point2D pt2) {
        double newDistance = Point2D.distance(pt1, pt2);
        Point2D p = Point2D.construct(this.x, this.y);
        if (newDistance == 0.0) {
            return Point2D.distance(p, pt1);
        }
        Point2D p2 = new Point2D();
        p2.setCoords(pt2);
        p2.sub(pt1);
        p.sub(pt1);
        double cross = p.crossProduct(p2);
        return cross / newDistance;
    }

    public static int orientationRobust(Point2D p, Point2D q, Point2D r) {
        ECoordinate det_ec = new ECoordinate();
        det_ec.set(q.x);
        det_ec.sub(p.x);
        ECoordinate rp_y_ec = new ECoordinate();
        rp_y_ec.set(r.y);
        rp_y_ec.sub(p.y);
        ECoordinate qp_y_ec = new ECoordinate();
        qp_y_ec.set(q.y);
        qp_y_ec.sub(p.y);
        ECoordinate rp_x_ec = new ECoordinate();
        rp_x_ec.set(r.x);
        rp_x_ec.sub(p.x);
        det_ec.mul(rp_y_ec);
        qp_y_ec.mul(rp_x_ec);
        det_ec.sub(qp_y_ec);
        if (!det_ec.isFuzzyZero()) {
            double det_ec_value = det_ec.value();
            if (det_ec_value < 0.0) {
                return -1;
            }
            if (det_ec_value > 0.0) {
                return 1;
            }
            return 0;
        }
        BigDecimal det_mp = new BigDecimal(q.x);
        BigDecimal px_mp = new BigDecimal(p.x);
        BigDecimal py_mp = new BigDecimal(p.y);
        det_mp = det_mp.subtract(px_mp);
        BigDecimal rp_y_mp = new BigDecimal(r.y);
        rp_y_mp = rp_y_mp.subtract(py_mp);
        BigDecimal qp_y_mp = new BigDecimal(q.y);
        qp_y_mp = qp_y_mp.subtract(py_mp);
        BigDecimal rp_x_mp = new BigDecimal(r.x);
        rp_x_mp = rp_x_mp.subtract(px_mp);
        det_mp = det_mp.multiply(rp_y_mp);
        qp_y_mp = qp_y_mp.multiply(rp_x_mp);
        det_mp = det_mp.subtract(qp_y_mp);
        return det_mp.signum();
    }

    private static int inCircleRobustMP_(Point2D p, Point2D q, Point2D r, Point2D s2) {
        BigDecimal sx_mp = new BigDecimal(s2.x);
        BigDecimal sy_mp = new BigDecimal(s2.y);
        BigDecimal psx_mp = new BigDecimal(p.x);
        BigDecimal psy_mp = new BigDecimal(p.y);
        psx_mp = psx_mp.subtract(sx_mp);
        psy_mp = psy_mp.subtract(sy_mp);
        BigDecimal qsx_mp = new BigDecimal(q.x);
        BigDecimal qsy_mp = new BigDecimal(q.y);
        qsx_mp = qsx_mp.subtract(sx_mp);
        qsy_mp = qsy_mp.subtract(sy_mp);
        BigDecimal rsx_mp = new BigDecimal(r.x);
        BigDecimal rsy_mp = new BigDecimal(r.y);
        rsx_mp = rsx_mp.subtract(sx_mp);
        rsy_mp = rsy_mp.subtract(sy_mp);
        BigDecimal pq_det_mp = psx_mp.multiply(qsy_mp).subtract(psy_mp.multiply(qsx_mp));
        BigDecimal qr_det_mp = qsx_mp.multiply(rsy_mp).subtract(qsy_mp.multiply(rsx_mp));
        BigDecimal pr_det_mp = psx_mp.multiply(rsy_mp).subtract(psy_mp.multiply(rsx_mp));
        BigDecimal p_parab_mp = psx_mp.multiply(psx_mp).add(psy_mp.multiply(psy_mp));
        BigDecimal q_parab_mp = qsx_mp.multiply(qsx_mp).add(qsy_mp.multiply(qsy_mp));
        BigDecimal r_parab_mp = rsx_mp.multiply(rsx_mp).add(rsy_mp.multiply(rsy_mp));
        BigDecimal det_mp = p_parab_mp.multiply(qr_det_mp).subtract(q_parab_mp.multiply(pr_det_mp)).add(r_parab_mp.multiply(pq_det_mp));
        return det_mp.signum();
    }

    static int inCircleRobust(Point2D p, Point2D q, Point2D r, Point2D s2) {
        ECoordinate psx_ec = new ECoordinate();
        ECoordinate psy_ec = new ECoordinate();
        psx_ec.set(p.x);
        psx_ec.sub(s2.x);
        psy_ec.set(p.y);
        psy_ec.sub(s2.y);
        ECoordinate qsx_ec = new ECoordinate();
        ECoordinate qsy_ec = new ECoordinate();
        qsx_ec.set(q.x);
        qsx_ec.sub(s2.x);
        qsy_ec.set(q.y);
        qsy_ec.sub(s2.y);
        ECoordinate rsx_ec = new ECoordinate();
        ECoordinate rsy_ec = new ECoordinate();
        rsx_ec.set(r.x);
        rsx_ec.sub(s2.x);
        rsy_ec.set(r.y);
        rsy_ec.sub(s2.y);
        ECoordinate psx_ec_qsy_ec = new ECoordinate();
        psx_ec_qsy_ec.set(psx_ec);
        psx_ec_qsy_ec.mul(qsy_ec);
        ECoordinate psy_ec_qsx_ec = new ECoordinate();
        psy_ec_qsx_ec.set(psy_ec);
        psy_ec_qsx_ec.mul(qsx_ec);
        ECoordinate qsx_ec_rsy_ec = new ECoordinate();
        qsx_ec_rsy_ec.set(qsx_ec);
        qsx_ec_rsy_ec.mul(rsy_ec);
        ECoordinate qsy_ec_rsx_ec = new ECoordinate();
        qsy_ec_rsx_ec.set(qsy_ec);
        qsy_ec_rsx_ec.mul(rsx_ec);
        ECoordinate psx_ec_rsy_ec = new ECoordinate();
        psx_ec_rsy_ec.set(psx_ec);
        psx_ec_rsy_ec.mul(rsy_ec);
        ECoordinate psy_ec_rsx_ec = new ECoordinate();
        psy_ec_rsx_ec.set(psy_ec);
        psy_ec_rsx_ec.mul(rsx_ec);
        ECoordinate pq_det_ec = new ECoordinate();
        pq_det_ec.set(psx_ec_qsy_ec);
        pq_det_ec.sub(psy_ec_qsx_ec);
        ECoordinate qr_det_ec = new ECoordinate();
        qr_det_ec.set(qsx_ec_rsy_ec);
        qr_det_ec.sub(qsy_ec_rsx_ec);
        ECoordinate pr_det_ec = new ECoordinate();
        pr_det_ec.set(psx_ec_rsy_ec);
        pr_det_ec.sub(psy_ec_rsx_ec);
        ECoordinate psx_ec_psx_ec = new ECoordinate();
        psx_ec_psx_ec.set(psx_ec);
        psx_ec_psx_ec.mul(psx_ec);
        ECoordinate psy_ec_psy_ec = new ECoordinate();
        psy_ec_psy_ec.set(psy_ec);
        psy_ec_psy_ec.mul(psy_ec);
        ECoordinate qsx_ec_qsx_ec = new ECoordinate();
        qsx_ec_qsx_ec.set(qsx_ec);
        qsx_ec_qsx_ec.mul(qsx_ec);
        ECoordinate qsy_ec_qsy_ec = new ECoordinate();
        qsy_ec_qsy_ec.set(qsy_ec);
        qsy_ec_qsy_ec.mul(qsy_ec);
        ECoordinate rsx_ec_rsx_ec = new ECoordinate();
        rsx_ec_rsx_ec.set(rsx_ec);
        rsx_ec_rsx_ec.mul(rsx_ec);
        ECoordinate rsy_ec_rsy_ec = new ECoordinate();
        rsy_ec_rsy_ec.set(rsy_ec);
        rsy_ec_rsy_ec.mul(rsy_ec);
        ECoordinate p_parab_ec = new ECoordinate();
        p_parab_ec.set(psx_ec_psx_ec);
        p_parab_ec.add(psy_ec_psy_ec);
        ECoordinate q_parab_ec = new ECoordinate();
        q_parab_ec.set(qsx_ec_qsx_ec);
        q_parab_ec.add(qsy_ec_qsy_ec);
        ECoordinate r_parab_ec = new ECoordinate();
        r_parab_ec.set(rsx_ec_rsx_ec);
        r_parab_ec.add(rsy_ec_rsy_ec);
        p_parab_ec.mul(qr_det_ec);
        q_parab_ec.mul(pr_det_ec);
        r_parab_ec.mul(pq_det_ec);
        ECoordinate det_ec = new ECoordinate();
        det_ec.set(p_parab_ec);
        det_ec.sub(q_parab_ec);
        det_ec.add(r_parab_ec);
        if (!det_ec.isFuzzyZero()) {
            double det_ec_value = det_ec.value();
            if (det_ec_value < 0.0) {
                return -1;
            }
            if (det_ec_value > 0.0) {
                return 1;
            }
            return 0;
        }
        return Point2D.inCircleRobustMP_(p, q, r, s2);
    }

    private static Point2D calculateCenterFromThreePointsHelperMP_(Point2D from, Point2D mid_point, Point2D to) {
        assert (!(mid_point.isEqual(to) || mid_point.isEqual(from) || from.isEqual(to)));
        BigDecimal mx = new BigDecimal(mid_point.x);
        mx = mx.subtract(new BigDecimal(from.x));
        BigDecimal my = new BigDecimal(mid_point.y);
        my = my.subtract(new BigDecimal(from.y));
        BigDecimal tx = new BigDecimal(to.x);
        tx = tx.subtract(new BigDecimal(from.x));
        BigDecimal ty = new BigDecimal(to.y);
        ty = ty.subtract(new BigDecimal(from.y));
        BigDecimal d = mx.multiply(ty);
        BigDecimal tmp = my.multiply(tx);
        if ((d = d.subtract(tmp)).signum() == 0) {
            return Point2D.construct(NumberUtils.NaN(), NumberUtils.NaN());
        }
        d = d.multiply(new BigDecimal(2.0));
        BigDecimal mx2 = mx.multiply(mx);
        BigDecimal my2 = my.multiply(my);
        BigDecimal m_norm2 = mx2.add(my2);
        BigDecimal tx2 = tx.multiply(tx);
        BigDecimal ty2 = ty.multiply(ty);
        BigDecimal t_norm2 = tx2.add(ty2);
        BigDecimal xo = my.multiply(t_norm2);
        tmp = ty.multiply(m_norm2);
        xo = xo.subtract(tmp);
        xo = xo.divide(d, 6);
        BigDecimal yo = mx.multiply(t_norm2);
        tmp = tx.multiply(m_norm2);
        yo = yo.subtract(tmp);
        yo = yo.divide(d, 6);
        Point2D center = Point2D.construct(from.x - xo.doubleValue(), from.y + yo.doubleValue());
        return center;
    }

    private static Point2D calculateCenterFromThreePointsHelper_(Point2D from, Point2D mid_point, Point2D to) {
        assert (!(mid_point.isEqual(to) || mid_point.isEqual(from) || from.isEqual(to)));
        ECoordinate mx = new ECoordinate(mid_point.x);
        mx.sub(from.x);
        ECoordinate my = new ECoordinate(mid_point.y);
        my.sub(from.y);
        ECoordinate tx = new ECoordinate(to.x);
        tx.sub(from.x);
        ECoordinate ty = new ECoordinate(to.y);
        ty.sub(from.y);
        ECoordinate d = new ECoordinate(mx);
        d.mul(ty);
        ECoordinate tmp = new ECoordinate(my);
        tmp.mul(tx);
        d.sub(tmp);
        if (d.value() == 0.0) {
            return Point2D.construct(NumberUtils.NaN(), NumberUtils.NaN());
        }
        d.mul(2.0);
        ECoordinate mx2 = new ECoordinate(mx);
        mx2.mul(mx);
        ECoordinate my2 = new ECoordinate(my);
        my2.mul(my);
        ECoordinate m_norm2 = new ECoordinate(mx2);
        m_norm2.add(my2);
        ECoordinate tx2 = new ECoordinate(tx);
        tx2.mul(tx);
        ECoordinate ty2 = new ECoordinate(ty);
        ty2.mul(ty);
        ECoordinate t_norm2 = new ECoordinate(tx2);
        t_norm2.add(ty2);
        ECoordinate xo = new ECoordinate(my);
        xo.mul(t_norm2);
        tmp = new ECoordinate(ty);
        tmp.mul(m_norm2);
        xo.sub(tmp);
        xo.div(d);
        ECoordinate yo = new ECoordinate(mx);
        yo.mul(t_norm2);
        tmp = new ECoordinate(tx);
        tmp.mul(m_norm2);
        yo.sub(tmp);
        yo.div(d);
        Point2D center = Point2D.construct(from.x - xo.value(), from.y + yo.value());
        double r1 = Point2D.construct(from.x - center.x, from.y - center.y).length();
        double r2 = Point2D.construct(mid_point.x - center.x, mid_point.y - center.y).length();
        double r3 = Point2D.construct(to.x - center.x, to.y - center.y).length();
        double base = r1 + Math.abs(from.x) + Math.abs(mid_point.x) + Math.abs(to.x) + Math.abs(from.y) + Math.abs(mid_point.y) + Math.abs(to.y);
        double tol = 1.0E-15;
        if (Math.abs(r1 - r2) <= base * tol && Math.abs(r1 - r3) <= base * tol) {
            return center;
        }
        return Point2D.construct(NumberUtils.NaN(), NumberUtils.NaN());
    }

    static Point2D calculateCircleCenterFromThreePoints(Point2D from, Point2D mid_point, Point2D to) {
        if (from.isEqual(to) || from.isEqual(mid_point) || to.isEqual(mid_point)) {
            return new Point2D(NumberUtils.NaN(), NumberUtils.NaN());
        }
        Point2D pt = Point2D.calculateCenterFromThreePointsHelper_(from, mid_point, to);
        if (pt.isNaN()) {
            return Point2D.calculateCenterFromThreePointsHelperMP_(from, mid_point, to);
        }
        return pt;
    }

    public int hashCode() {
        return NumberUtils.hash(NumberUtils.hash(this.x), this.y);
    }

    double getAxis(int ordinate) {
        assert (ordinate == 0 || ordinate == 1);
        return ordinate == 0 ? this.x : this.y;
    }

    static class CompareVectors
    implements Comparator<Point2D> {
        CompareVectors() {
        }

        @Override
        public int compare(Point2D v1, Point2D v2) {
            return Point2D._compareVectors(v1, v2);
        }
    }
}

