/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.calcite.$internal.com.jayway.jsonpath.spi.json;

import com.linkedin.coral.calcite.$internal.com.jayway.jsonpath.JsonPathException;
import com.linkedin.coral.calcite.$internal.com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class AbstractJsonProvider
implements JsonProvider {
    @Override
    public boolean isArray(Object obj) {
        return obj instanceof List;
    }

    @Override
    public Object getArrayIndex(Object obj, int idx) {
        return ((List)obj).get(idx);
    }

    @Override
    public final Object getArrayIndex(Object obj, int idx, boolean unwrap) {
        return this.getArrayIndex(obj, idx);
    }

    @Override
    public void setArrayIndex(Object array, int index, Object newValue) {
        if (!this.isArray(array)) {
            throw new UnsupportedOperationException();
        }
        List l = (List)array;
        if (index == l.size()) {
            l.add(newValue);
        } else {
            l.set(index, newValue);
        }
    }

    @Override
    public Object getMapValue(Object obj, String key) {
        Map m3 = (Map)obj;
        if (!m3.containsKey(key)) {
            return JsonProvider.UNDEFINED;
        }
        return m3.get(key);
    }

    @Override
    public void setProperty(Object obj, Object key, Object value) {
        if (!this.isMap(obj)) {
            throw new JsonPathException("setProperty operation cannot be used with " + obj != null ? obj.getClass().getName() : "null");
        }
        ((Map)obj).put(key.toString(), value);
    }

    @Override
    public void removeProperty(Object obj, Object key) {
        if (this.isMap(obj)) {
            ((Map)obj).remove(key.toString());
        } else {
            List list = (List)obj;
            int index = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
            list.remove(index);
        }
    }

    @Override
    public boolean isMap(Object obj) {
        return obj instanceof Map;
    }

    @Override
    public Collection<String> getPropertyKeys(Object obj) {
        if (this.isArray(obj)) {
            throw new UnsupportedOperationException();
        }
        return ((Map)obj).keySet();
    }

    @Override
    public int length(Object obj) {
        if (this.isArray(obj)) {
            return ((List)obj).size();
        }
        if (this.isMap(obj)) {
            return this.getPropertyKeys(obj).size();
        }
        if (obj instanceof String) {
            return ((String)obj).length();
        }
        throw new JsonPathException("length operation cannot be applied to " + obj != null ? obj.getClass().getName() : "null");
    }

    public Iterable<? extends Object> toIterable(Object obj) {
        if (this.isArray(obj)) {
            return (Iterable)obj;
        }
        throw new JsonPathException("Cannot iterate over " + obj != null ? obj.getClass().getName() : "null");
    }

    @Override
    public Object unwrap(Object obj) {
        return obj;
    }
}

