/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.transformers;

import com.linkedin.coral.common.transformers.SqlCallTransformer;
import com.linkedin.coral.common.utils.TypeDerivationUtil;
import java.math.BigDecimal;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.SqlTypeName;

public class ShiftArrayIndexTransformer
extends SqlCallTransformer {
    private static final String ITEM_OPERATOR = "ITEM";

    public ShiftArrayIndexTransformer(TypeDerivationUtil typeDerivationUtil) {
        super(typeDerivationUtil);
    }

    @Override
    public boolean condition(SqlCall sqlCall) {
        if (ITEM_OPERATOR.equalsIgnoreCase(sqlCall.getOperator().getName())) {
            SqlNode columnNode = sqlCall.getOperandList().get(0);
            return this.deriveRelDatatype(columnNode) instanceof ArraySqlType;
        }
        return false;
    }

    @Override
    public SqlCall transform(SqlCall sqlCall) {
        SqlNode newIndex;
        SqlNode itemNode = sqlCall.getOperandList().get(1);
        if (itemNode instanceof SqlNumericLiteral && this.deriveRelDatatype(itemNode).getSqlTypeName().equals((Object)SqlTypeName.INTEGER)) {
            Integer value = ((SqlNumericLiteral)itemNode).getValueAs(Integer.class);
            newIndex = SqlNumericLiteral.createExactNumeric(new BigDecimal(value + 1).toString(), itemNode.getParserPosition());
        } else {
            newIndex = SqlStdOperatorTable.PLUS.createCall(itemNode.getParserPosition(), itemNode, SqlNumericLiteral.createExactNumeric("1", SqlParserPos.ZERO));
        }
        return SqlStdOperatorTable.ITEM.createCall(SqlParserPos.ZERO, sqlCall.getOperandList().get(0), newIndex);
    }
}

