/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableMap;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.FunctionExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class SqlUserDefinedTableMacro
extends SqlFunction {
    private final TableMacro tableMacro;

    public SqlUserDefinedTableMacro(SqlIdentifier opName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, List<RelDataType> paramTypes, TableMacro tableMacro) {
        super(Util.last(opName.names), opName, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandTypeChecker, Objects.requireNonNull(paramTypes), SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
        this.tableMacro = tableMacro;
    }

    @Override
    public List<String> getParamNames() {
        return Lists.transform(this.tableMacro.getParameters(), FunctionParameter::getName);
    }

    public TranslatableTable getTable(RelDataTypeFactory typeFactory, List<SqlNode> operandList) {
        List<Object> arguments = SqlUserDefinedTableMacro.convertArguments(typeFactory, operandList, this.tableMacro, this.getNameAsId(), true);
        return this.tableMacro.apply(arguments);
    }

    public static List<Object> convertArguments(RelDataTypeFactory typeFactory, List<SqlNode> operandList, Function function, SqlIdentifier opName, boolean failOnNonLiteral) {
        ArrayList<Object> arguments = new ArrayList<Object>(operandList.size());
        for (Pair<FunctionParameter, SqlNode> pair : Pair.zip(function.getParameters(), operandList)) {
            try {
                Object o = SqlUserDefinedTableMacro.getValue((SqlNode)pair.right);
                Object o2 = SqlUserDefinedTableMacro.coerce(o, ((FunctionParameter)pair.left).getType(typeFactory));
                arguments.add(o2);
            }
            catch (NonLiteralException e) {
                if (failOnNonLiteral) {
                    throw new IllegalArgumentException("All arguments of call to macro " + opName + " should be literal. Actual argument #" + ((FunctionParameter)pair.left).getOrdinal() + " (" + ((FunctionParameter)pair.left).getName() + ") is not literal: " + pair.right);
                }
                RelDataType type = ((FunctionParameter)pair.left).getType(typeFactory);
                Long value = type.isNullable() ? null : Long.valueOf(0L);
                arguments.add(value);
            }
        }
        return arguments;
    }

    private static Object getValue(SqlNode right) throws NonLiteralException {
        switch (right.getKind()) {
            case ARRAY_VALUE_CONSTRUCTOR: {
                ArrayList<Object> list = new ArrayList<Object>();
                for (SqlNode o : ((SqlCall)right).getOperandList()) {
                    list.add(SqlUserDefinedTableMacro.getValue(o));
                }
                return ImmutableNullableList.copyOf(list);
            }
            case MAP_VALUE_CONSTRUCTOR: {
                ImmutableMap.Builder<Object, Object> builder2 = ImmutableMap.builder();
                List<SqlNode> operands = ((SqlCall)right).getOperandList();
                for (int i = 0; i < operands.size(); i += 2) {
                    SqlNode key = operands.get(i);
                    SqlNode value = operands.get(i + 1);
                    builder2.put(SqlUserDefinedTableMacro.getValue(key), SqlUserDefinedTableMacro.getValue(value));
                }
                return builder2.build();
            }
        }
        if (SqlUtil.isNullLiteral(right, true)) {
            return null;
        }
        if (SqlUtil.isLiteral(right)) {
            return ((SqlLiteral)right).getValue();
        }
        if (right.getKind() == SqlKind.DEFAULT) {
            return null;
        }
        throw new NonLiteralException();
    }

    private static Object coerce(Object o, RelDataType type) {
        if (o == null) {
            return null;
        }
        if (!(type instanceof RelDataTypeFactoryImpl.JavaType)) {
            return null;
        }
        RelDataTypeFactoryImpl.JavaType javaType = (RelDataTypeFactoryImpl.JavaType)type;
        Class clazz = javaType.getJavaClass();
        if (clazz.isAssignableFrom(o.getClass())) {
            return o;
        }
        if (clazz == String.class && o instanceof NlsString) {
            return ((NlsString)o).getValue();
        }
        BlockBuilder bb = new BlockBuilder();
        Expression expr = RexToLixTranslator.convert(Expressions.constant(o), clazz);
        bb.add(Expressions.return_(null, expr));
        FunctionExpression convert = Expressions.lambda(bb.toBlock(), Collections.emptyList());
        return convert.compile().dynamicInvoke(new Object[0]);
    }

    private static class NonLiteralException
    extends Exception {
        private NonLiteralException() {
        }
    }
}

