/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import io.trino.filesystem.Location;
import java.io.IOException;
import java.io.OutputStream;

public final class AlluxioTrinoOutputStream
extends OutputStream {
    private final Location location;
    private final OutputStream delegate;
    private volatile boolean closed;

    public AlluxioTrinoOutputStream(Location location, OutputStream delegate) {
        this.location = location;
        this.delegate = delegate;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureOpen();
        this.delegate.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.delegate.close();
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Output stream for %s closed: ".formatted(this.location));
        }
    }
}

