/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem;

import com.google.common.base.Throwables;
import io.airlift.units.Duration;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemException;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.UriLocation;
import io.trino.filesystem.encryption.EncryptionKey;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;

public interface TrinoFileSystem {
    public TrinoInputFile newInputFile(Location var1);

    default public TrinoInputFile newEncryptedInputFile(Location location, EncryptionKey key) {
        throw new UnsupportedOperationException("Server side encryption is not supported");
    }

    public TrinoInputFile newInputFile(Location var1, long var2);

    default public TrinoInputFile newEncryptedInputFile(Location location, long length, EncryptionKey key) {
        throw new UnsupportedOperationException("Server side encryption is not supported");
    }

    public TrinoInputFile newInputFile(Location var1, long var2, Instant var4);

    default public TrinoInputFile newEncryptedInputFile(Location location, long length, Instant lastModified, EncryptionKey key) {
        throw new UnsupportedOperationException("Server side encryption is not supported");
    }

    public TrinoOutputFile newOutputFile(Location var1);

    default public TrinoOutputFile newEncryptedOutputFile(Location location, EncryptionKey key) {
        throw new UnsupportedOperationException("Server side encryption is not supported");
    }

    public void deleteFile(Location var1) throws IOException;

    default public void deleteFiles(Collection<Location> locations) throws IOException {
        for (Location location : locations) {
            this.deleteFile(location);
        }
    }

    public void deleteDirectory(Location var1) throws IOException;

    public void renameFile(Location var1, Location var2) throws IOException;

    public FileIterator listFiles(Location var1) throws IOException;

    public Optional<Boolean> directoryExists(Location var1) throws IOException;

    public void createDirectory(Location var1) throws IOException;

    public void renameDirectory(Location var1, Location var2) throws IOException;

    public Set<Location> listDirectories(Location var1) throws IOException;

    public Optional<Location> createTemporaryDirectory(Location var1, String var2, String var3) throws IOException;

    default public Optional<UriLocation> preSignedUri(Location location, Duration ttl) throws IOException {
        throw new UnsupportedOperationException("Pre-signed URIs are not supported by " + this.getClass().getSimpleName());
    }

    default public Optional<UriLocation> encryptedPreSignedUri(Location location, Duration ttl, EncryptionKey key) throws IOException {
        throw new UnsupportedOperationException("Encrypted pre-signed URIs are not supported by " + this.getClass().getSimpleName());
    }

    public static boolean isUnrecoverableException(Throwable throwable) {
        return Throwables.getCausalChain((Throwable)throwable).stream().anyMatch(t -> t instanceof TrinoFileSystemException || t instanceof FileNotFoundException || t instanceof UnsupportedOperationException);
    }
}

