/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.builder;

import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.projectnessie.client.api.GetAllReferencesBuilder;
import org.projectnessie.client.builder.StreamingUtil;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.FetchOption;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;

public abstract class BaseGetAllReferencesBuilder<PARAMS>
implements GetAllReferencesBuilder {
    private final BiFunction<PARAMS, String, PARAMS> paramsForPage;
    private String pageToken;
    protected Integer maxRecords;
    protected FetchOption fetchOption;
    protected String filter;

    protected BaseGetAllReferencesBuilder(BiFunction<PARAMS, String, PARAMS> paramsForPage) {
        this.paramsForPage = paramsForPage;
    }

    @Override
    public GetAllReferencesBuilder maxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
        return this;
    }

    @Override
    public GetAllReferencesBuilder pageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
    }

    @Override
    public GetAllReferencesBuilder fetch(FetchOption fetchOption) {
        this.fetchOption = fetchOption;
        return this;
    }

    @Override
    public GetAllReferencesBuilder filter(String filter) {
        this.filter = filter;
        return this;
    }

    protected abstract PARAMS params();

    protected abstract ReferencesResponse get(PARAMS var1);

    @Override
    public ReferencesResponse get() {
        PARAMS p = this.paramsForPage.apply(this.params(), this.pageToken);
        return this.get(p);
    }

    @Override
    public Stream<Reference> stream() throws NessieNotFoundException {
        PARAMS p = this.params();
        return StreamingUtil.generateStream(ReferencesResponse::getReferences, pageToken -> this.get(this.paramsForPage.apply(p, pageToken)));
    }
}

