/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl.jdk8;

import java.net.URI;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.client.http.impl.HttpRuntimeConfig;
import org.projectnessie.client.http.impl.jdk8.UrlConnectionRequest;

final class UrlConnectionClient
implements HttpClient {
    public static final String UNSUPPORTED_CONFIG_MESSAGE = "Nessie's URLConnection client does not support the configuration options to specify SSL parameters. Switch to Java 11 instead.";
    private final HttpRuntimeConfig config;

    UrlConnectionClient(HttpRuntimeConfig config) {
        this.config = config;
        if (config.getSslParameters() != null) {
            throw new IllegalArgumentException(UNSUPPORTED_CONFIG_MESSAGE);
        }
    }

    @Override
    public HttpRequest newRequest(URI baseUri) {
        return new UrlConnectionRequest(this.config, baseUri);
    }

    @Override
    public URI getBaseUri() {
        return this.config.getBaseUri();
    }

    @Override
    public void close() {
        this.config.close();
    }
}

