/*
 * Decompiled with CFR 0.152.
 */
package alluxio.collections;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class DirectedAcyclicGraphNode<T> {
    private final T mPayload;
    private final List<DirectedAcyclicGraphNode<T>> mParents;
    private final List<DirectedAcyclicGraphNode<T>> mChildren;

    public DirectedAcyclicGraphNode(T payload, List<DirectedAcyclicGraphNode<T>> parents, List<DirectedAcyclicGraphNode<T>> children) {
        this.mPayload = Preconditions.checkNotNull(payload, (Object)"payload");
        this.mParents = (List)Preconditions.checkNotNull(parents, (Object)"parents");
        this.mChildren = (List)Preconditions.checkNotNull(children, (Object)"children");
    }

    public DirectedAcyclicGraphNode(T payload) {
        this(payload, new ArrayList<DirectedAcyclicGraphNode<T>>(), new ArrayList<DirectedAcyclicGraphNode<T>>());
    }

    public T getPayload() {
        return this.mPayload;
    }

    public List<DirectedAcyclicGraphNode<T>> getParents() {
        return this.mParents;
    }

    public List<DirectedAcyclicGraphNode<T>> getChildren() {
        return this.mChildren;
    }

    public void addParent(DirectedAcyclicGraphNode<T> parent) {
        this.mParents.add(parent);
    }

    public void addChild(DirectedAcyclicGraphNode<T> child) {
        this.mChildren.add(child);
    }

    public void removeChild(DirectedAcyclicGraphNode<T> child) {
        Preconditions.checkState((boolean)this.mChildren.contains(child));
        this.mChildren.remove(child);
    }
}

