/*
 * Decompiled with CFR 0.152.
 */
package alluxio.collections;

import alluxio.collections.ConcurrentHashSet;
import alluxio.collections.FieldIndex;
import alluxio.collections.IndexDefinition;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class NonUniqueFieldIndex<T, V>
implements FieldIndex<T, V> {
    private final IndexDefinition<T, V> mIndexDefinition;
    private final ConcurrentHashMap<V, ConcurrentHashSet<T>> mIndexMap = new ConcurrentHashMap(8, 0.95f, 8);

    public NonUniqueFieldIndex(IndexDefinition<T, V> indexDefinition) {
        this.mIndexDefinition = indexDefinition;
    }

    @Override
    public boolean add(T object) {
        AtomicBoolean res = new AtomicBoolean(false);
        V fieldValue = this.mIndexDefinition.getFieldValue(object);
        this.mIndexMap.compute((ConcurrentHashSet)fieldValue, (BiFunction<ConcurrentHashSet, ConcurrentHashSet<T>, ConcurrentHashSet<T>>)((BiFunction<Object, ConcurrentHashSet, ConcurrentHashSet>)(value, set) -> {
            if (set == null) {
                set = new ConcurrentHashSet<Object>();
            }
            res.set(set.add(object));
            return set;
        }));
        return res.get();
    }

    @Override
    public boolean remove(T object) {
        AtomicBoolean res = new AtomicBoolean(false);
        V fieldValue = this.mIndexDefinition.getFieldValue(object);
        this.mIndexMap.computeIfPresent((ConcurrentHashSet)fieldValue, (BiFunction<ConcurrentHashSet, ConcurrentHashSet<T>, ConcurrentHashSet<T>>)((BiFunction<Object, ConcurrentHashSet, ConcurrentHashSet>)(value, set) -> {
            res.set(set.remove(object));
            if (set.isEmpty()) {
                return null;
            }
            return set;
        }));
        return res.get();
    }

    @Override
    public void clear() {
        this.mIndexMap.clear();
    }

    @Override
    public boolean containsField(V fieldValue) {
        return this.mIndexMap.containsKey(fieldValue);
    }

    @Override
    public boolean containsObject(T object) {
        V fieldValue = this.mIndexDefinition.getFieldValue(object);
        ConcurrentHashSet<T> set = this.mIndexMap.get(fieldValue);
        if (set == null) {
            return false;
        }
        return set.contains(object);
    }

    @Override
    public Set<T> getByField(V value) {
        Set set = this.mIndexMap.get(value);
        return set == null ? Collections.emptySet() : set;
    }

    @Override
    public T getFirst(V value) {
        Set all = this.mIndexMap.get(value);
        return (T)(all == null ? null : Iterables.getFirst((Iterable)all, null));
    }

    @Override
    public Iterator<T> iterator() {
        return new NonUniqueFieldIndexIterator();
    }

    @Override
    public int size() {
        int totalSize = 0;
        for (ConcurrentHashSet<T> innerSet : this.mIndexMap.values()) {
            totalSize += innerSet.size();
        }
        return totalSize;
    }

    private class NonUniqueFieldIndexIterator
    implements Iterator<T> {
        private final Iterator<ConcurrentHashSet<T>> mIndexIterator;
        private Iterator<T> mObjectIterator;
        private T mObject;

        public NonUniqueFieldIndexIterator() {
            this.mIndexIterator = NonUniqueFieldIndex.this.mIndexMap.values().iterator();
            this.mObjectIterator = null;
            this.mObject = null;
        }

        @Override
        public boolean hasNext() {
            if (this.mObjectIterator != null && this.mObjectIterator.hasNext()) {
                return true;
            }
            while (this.mIndexIterator.hasNext()) {
                this.mObjectIterator = this.mIndexIterator.next().iterator();
                if (!this.mObjectIterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            while (this.mObjectIterator == null || !this.mObjectIterator.hasNext()) {
                this.mObjectIterator = this.mIndexIterator.next().iterator();
            }
            Object next = this.mObjectIterator.next();
            this.mObject = next;
            return next;
        }

        @Override
        public void remove() {
            if (this.mObject == null) {
                throw new IllegalStateException("next() was not called before remove()");
            }
            NonUniqueFieldIndex.this.remove(this.mObject);
            this.mObject = null;
        }
    }
}

