/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master;

import alluxio.exception.status.UnavailableException;
import alluxio.master.MasterInquireClient;
import alluxio.uri.Authority;
import alluxio.uri.ZookeeperAuthority;
import alluxio.util.CommonUtils;
import alluxio.util.io.PathUtils;
import alluxio.util.network.NetworkAddressUtils;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ZookeeperFactory;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ZkMasterInquireClient
implements MasterInquireClient,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ZkMasterInquireClient.class);
    private static final HashMap<ZkMasterConnectDetails, ZkMasterInquireClient> CREATED_CLIENTS = new HashMap();
    private final ZkMasterConnectDetails mConnectDetails;
    private final String mElectionPath;
    private final CuratorFramework mClient;
    private final int mInquireRetryCount;

    public static synchronized ZkMasterInquireClient getClient(String zookeeperAddress, String electionPath, String leaderPath, int inquireRetryCount, boolean authEnabled) {
        ZkMasterConnectDetails connectDetails = new ZkMasterConnectDetails(zookeeperAddress, leaderPath);
        if (!CREATED_CLIENTS.containsKey(connectDetails)) {
            CREATED_CLIENTS.put(connectDetails, new ZkMasterInquireClient(connectDetails, electionPath, inquireRetryCount, authEnabled));
        }
        return CREATED_CLIENTS.get(connectDetails);
    }

    private ZkMasterInquireClient(ZkMasterConnectDetails connectDetails, String electionPath, int inquireRetryCount, boolean authEnabled) {
        this.mConnectDetails = connectDetails;
        this.mElectionPath = electionPath;
        LOG.info("Creating new zookeeper client for {}", (Object)connectDetails);
        CuratorFrameworkFactory.Builder curatorBuilder = CuratorFrameworkFactory.builder();
        curatorBuilder.connectString(connectDetails.getZkAddress());
        curatorBuilder.retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3));
        curatorBuilder.zookeeperFactory((ZookeeperFactory)new AlluxioZookeeperFactory(authEnabled));
        curatorBuilder.zk34CompatibilityMode(true);
        curatorBuilder.dontUseContainerParents();
        this.mClient = curatorBuilder.build();
        this.mInquireRetryCount = inquireRetryCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized InetSocketAddress getPrimaryRpcAddress() throws UnavailableException {
        this.ensureStarted();
        long startTime = System.currentTimeMillis();
        int tried = 0;
        try {
            CuratorZookeeperClient curatorClient = this.mClient.getZookeeperClient();
            for (int i = 0; i < 50 && !curatorClient.isConnected(); ++i) {
                CommonUtils.sleepMs(20L);
            }
            curatorClient.blockUntilConnectedOrTimedOut();
            String leaderPath = this.mConnectDetails.getLeaderPath();
            while (tried++ < this.mInquireRetryCount) {
                ZooKeeper zookeeper = curatorClient.getZooKeeper();
                if (zookeeper.exists(leaderPath, false) != null) {
                    List masters = zookeeper.getChildren(leaderPath, null);
                    LOG.debug("Master addresses: {}", (Object)masters);
                    if (masters.size() >= 1) {
                        if (masters.size() == 1) {
                            InetSocketAddress inetSocketAddress = NetworkAddressUtils.parseInetSocketAddress((String)masters.get(0));
                            return inetSocketAddress;
                        }
                        long maxTime = 0L;
                        String leader = "";
                        for (String master : masters) {
                            Stat stat = zookeeper.exists(PathUtils.concatPath((Object)leaderPath, (Object)master), null);
                            if (stat == null || stat.getCtime() <= maxTime) continue;
                            maxTime = stat.getCtime();
                            leader = master;
                        }
                        LOG.debug("The leader master: {}", (Object)leader);
                        InetSocketAddress inetSocketAddress = NetworkAddressUtils.parseInetSocketAddress(leader);
                        return inetSocketAddress;
                    }
                } else {
                    LOG.info("{} does not exist ({})", (Object)leaderPath, (Object)tried);
                }
                CommonUtils.sleepMs(LOG, 1000L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOG.error("Error getting the leader master address from zookeeper. Zookeeper: {}", (Object)this.mConnectDetails, (Object)e);
        }
        finally {
            LOG.debug("Finished getPrimaryRpcAddress() in {}ms", (Object)(System.currentTimeMillis() - startTime));
        }
        throw new UnavailableException("Failed to determine primary master rpc address");
    }

    @Override
    public synchronized List<InetSocketAddress> getMasterRpcAddresses() throws UnavailableException {
        this.ensureStarted();
        int tried = 0;
        try {
            while (tried < this.mInquireRetryCount) {
                if (this.mClient.checkExists().forPath(this.mElectionPath) != null) {
                    List children = (List)this.mClient.getChildren().forPath(this.mElectionPath);
                    ArrayList<InetSocketAddress> ret = new ArrayList<InetSocketAddress>();
                    for (String child : children) {
                        byte[] data = (byte[])this.mClient.getData().forPath(PathUtils.concatPath((Object)this.mElectionPath, (Object)child));
                        if (data == null) continue;
                        ret.add(NetworkAddressUtils.parseInetSocketAddress(new String(data, StandardCharsets.UTF_8)));
                    }
                    LOG.info("All masters: {}", ret);
                    return ret;
                }
                LOG.info("{} does not exist ({})", (Object)this.mElectionPath, (Object)(++tried));
            }
        }
        catch (Exception e) {
            LOG.error("Error getting the master addresses from zookeeper. Zookeeper: {}", (Object)this.mConnectDetails, (Object)e);
        }
        throw new UnavailableException("Failed to query zookeeper for master RPC addresses");
    }

    private synchronized void ensureStarted() {
        switch (this.mClient.getState()) {
            case LATENT: {
                this.mClient.start();
                return;
            }
            case STARTED: {
                return;
            }
            case STOPPED: {
                throw new IllegalStateException("Client has already been closed");
            }
        }
        throw new IllegalStateException("Unknown state: " + this.mClient.getState());
    }

    @Override
    public void close() {
        this.mClient.close();
    }

    @Override
    public MasterInquireClient.ConnectDetails getConnectDetails() {
        return this.mConnectDetails;
    }

    public static class ZkMasterConnectDetails
    implements MasterInquireClient.ConnectDetails {
        private final String mZkAddress;
        private final String mLeaderPath;

        public ZkMasterConnectDetails(String zkAddress, String leaderPath) {
            this.mZkAddress = zkAddress;
            this.mLeaderPath = leaderPath;
        }

        public String getZkAddress() {
            return this.mZkAddress;
        }

        public String getLeaderPath() {
            return this.mLeaderPath;
        }

        @Override
        public Authority toAuthority() {
            return new ZookeeperAuthority(this.mZkAddress);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ZkMasterConnectDetails)) {
                return false;
            }
            ZkMasterConnectDetails that = (ZkMasterConnectDetails)o;
            return this.mZkAddress.equals(that.mZkAddress) && this.mLeaderPath.equals(that.mLeaderPath);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.mZkAddress, this.mLeaderPath);
        }

        public String toString() {
            return this.toAuthority() + this.mLeaderPath;
        }
    }

    private static class AlluxioZookeeperFactory
    implements ZookeeperFactory {
        private final boolean mAuthEnabled;

        public AlluxioZookeeperFactory(boolean authEnabled) {
            this.mAuthEnabled = authEnabled;
        }

        public ZooKeeper newZooKeeper(String connectString, int sessionTimeout, Watcher watcher, boolean canBeReadOnly) throws Exception {
            ZKClientConfig zkConfig = new ZKClientConfig();
            zkConfig.setProperty("zookeeper.sasl.client", Boolean.toString(this.mAuthEnabled).toLowerCase());
            return new ZooKeeper(connectString, sessionTimeout, watcher, zkConfig);
        }
    }
}

