/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authorization;

import alluxio.exception.ExceptionMessage;
import alluxio.security.authorization.Mode;
import java.text.MessageFormat;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;

@ThreadSafe
public final class ModeParser {
    private static final char[] VALID_TARGETS = new char[]{'u', 'g', 'o', 'a'};
    private static final char[] VALID_PERMISSIONS = new char[]{'r', 'w', 'x'};

    private ModeParser() {
    }

    public static Mode parse(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException(ExceptionMessage.INVALID_MODE.getMessage(value));
        }
        try {
            return ModeParser.parseNumeric(value);
        }
        catch (NumberFormatException e) {
            return ModeParser.parseSymbolic(value);
        }
    }

    private static Mode parseNumeric(String value) {
        short s = Short.parseShort(value, 8);
        return new Mode(s);
    }

    private static Mode parseSymbolic(String value) {
        String[] specs;
        String[] stringArray;
        Mode.Bits ownerBits = Mode.Bits.NONE;
        Mode.Bits groupBits = Mode.Bits.NONE;
        Mode.Bits otherBits = Mode.Bits.NONE;
        if (value.contains(",")) {
            stringArray = value.split(",");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        }
        for (String spec : specs = stringArray) {
            String[] specParts = spec.split("=");
            if (specParts.length != 2) {
                throw new IllegalArgumentException(ExceptionMessage.INVALID_MODE_SEGMENT.getMessage(value, spec));
            }
            if (!StringUtils.containsOnly((CharSequence)specParts[0], (char[])VALID_TARGETS)) {
                throw new IllegalArgumentException(MessageFormat.format("Invalid mode {0} - contains invalid segment {1} which has invalid targets {2}", value, spec, specParts[0]));
            }
            if (!StringUtils.containsOnly((CharSequence)specParts[1], (char[])VALID_PERMISSIONS)) {
                throw new IllegalArgumentException(MessageFormat.format("Invalid mode {0} - contains invalid segment {1} which has invalid permissions {2}", value, spec, specParts[1]));
            }
            Mode.Bits specBits = Mode.Bits.NONE;
            block12: for (char permChar : specParts[1].toCharArray()) {
                switch (permChar) {
                    case 'r': {
                        specBits = specBits.or(Mode.Bits.READ);
                        continue block12;
                    }
                    case 'w': {
                        specBits = specBits.or(Mode.Bits.WRITE);
                        continue block12;
                    }
                    case 'x': {
                        specBits = specBits.or(Mode.Bits.EXECUTE);
                        continue block12;
                    }
                    default: {
                        throw new IllegalStateException("Unknown permission character: " + permChar);
                    }
                }
            }
            block13: for (char targetChar : specParts[0].toCharArray()) {
                switch (targetChar) {
                    case 'u': {
                        ownerBits = ownerBits.or(specBits);
                        continue block13;
                    }
                    case 'g': {
                        groupBits = groupBits.or(specBits);
                        continue block13;
                    }
                    case 'o': {
                        otherBits = otherBits.or(specBits);
                        continue block13;
                    }
                    case 'a': {
                        ownerBits = ownerBits.or(specBits);
                        groupBits = groupBits.or(specBits);
                        otherBits = otherBits.or(specBits);
                        continue block13;
                    }
                    default: {
                        throw new IllegalStateException("Unknown target character: " + targetChar);
                    }
                }
            }
        }
        return new Mode(ownerBits, groupBits, otherBits);
    }
}

