/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.conf.PropertyKey;
import alluxio.exception.ExceptionMessage;
import alluxio.grpc.PMode;
import alluxio.security.authorization.Mode;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ModeUtils {
    private static final Mode FILE_UMASK = new Mode(73);

    private ModeUtils() {
    }

    public static Mode applyFileUMask(Mode mode, String authUmask) {
        mode = ModeUtils.applyUMask(mode, ModeUtils.getUMask(authUmask));
        mode = ModeUtils.applyUMask(mode, FILE_UMASK);
        return mode;
    }

    public static Mode applyDirectoryUMask(Mode mode, String authUmask) {
        return ModeUtils.applyUMask(mode, ModeUtils.getUMask(authUmask));
    }

    public static short protoToShort(PMode pMode) {
        return Mode.fromProto(pMode).toShort();
    }

    private static Mode applyUMask(Mode mode, Mode umask) {
        mode.setOwnerBits(mode.getOwnerBits().and(umask.getOwnerBits().not()));
        mode.setGroupBits(mode.getGroupBits().and(umask.getGroupBits().not()));
        mode.setOtherBits(mode.getOtherBits().and(umask.getOtherBits().not()));
        return mode;
    }

    public static Mode getUMask(@Nullable String confUmask) {
        int umask = 18;
        if (confUmask != null) {
            if (confUmask.length() > 4 || !ModeUtils.isValid(confUmask)) {
                throw new IllegalArgumentException(ExceptionMessage.INVALID_CONFIGURATION_VALUE.getMessage(confUmask, PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK));
            }
            int newUmask = 0;
            int lastIndex = confUmask.length() - 1;
            for (int i = 0; i <= lastIndex; ++i) {
                newUmask += confUmask.charAt(i) - 48 << 3 * (lastIndex - i);
            }
            umask = newUmask;
        }
        return new Mode((short)umask);
    }

    private static boolean isValid(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

