/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.drift.client;

import io.airlift.drift.client.DriftClientFactory;
import io.airlift.drift.client.ExceptionClassifier;
import io.airlift.drift.client.address.AddressSelector;
import io.airlift.drift.client.stats.MethodInvocationStatsFactory;
import io.airlift.drift.client.stats.NullMethodInvocationStatsFactory;
import io.airlift.drift.codec.ThriftCodecManager;
import io.airlift.drift.transport.client.MethodInvokerFactory;
import java.util.Objects;

public class DriftClientFactoryManager<I> {
    private final ThriftCodecManager codecManager;
    private final MethodInvokerFactory<I> methodInvokerFactory;
    private final MethodInvocationStatsFactory methodInvocationStatsFactory;

    public DriftClientFactoryManager(ThriftCodecManager codecManager, MethodInvokerFactory<I> methodInvokerFactory) {
        this(codecManager, methodInvokerFactory, new NullMethodInvocationStatsFactory());
    }

    public DriftClientFactoryManager(ThriftCodecManager codecManager, MethodInvokerFactory<I> methodInvokerFactory, MethodInvocationStatsFactory methodInvocationStatsFactory) {
        this.codecManager = Objects.requireNonNull(codecManager, "codecManager is null");
        this.methodInvokerFactory = Objects.requireNonNull(methodInvokerFactory, "methodInvokerFactory is null");
        this.methodInvocationStatsFactory = methodInvocationStatsFactory;
    }

    public DriftClientFactory createDriftClientFactory(I clientIdentity, AddressSelector<?> addressSelector, ExceptionClassifier exceptionClassifier) {
        return new DriftClientFactory(this.codecManager, () -> this.methodInvokerFactory.createMethodInvoker(clientIdentity), addressSelector, exceptionClassifier, this.methodInvocationStatsFactory);
    }
}

