/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;

public class IgnoreForwardedRequestCustomizer
implements HttpConfiguration.Customizer {
    private static final String X_FORWARDED_PREFIX = "x-forwarded-";

    public Request customize(Request request, HttpFields.Mutable responseHeaders) {
        Set headersToRemove = (Set)request.getHeaders().stream().filter(IgnoreForwardedRequestCustomizer::isForwardingHeader).collect(ImmutableSet.toImmutableSet());
        HttpFields original = request.getHeaders();
        HttpFields.Mutable builder = HttpFields.build((int)(original.size() - headersToRemove.size()));
        original.forEach(httpField -> {
            if (!headersToRemove.contains(httpField)) {
                builder.add(httpField);
            }
        });
        final HttpFields headers = builder.asImmutable();
        return new Request.Wrapper(this, request){

            public HttpFields getHeaders() {
                return headers;
            }
        };
    }

    private static boolean isForwardingHeader(HttpField httpField) {
        return httpField.getName().regionMatches(true, 0, X_FORWARDED_PREFIX, 0, X_FORWARDED_PREFIX.length());
    }
}

