/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.message.server;

import com.singlestore.jdbc.client.ReadableByteBuf;
import com.singlestore.jdbc.message.ServerMessage;

public final class InitialHandshakePacket
implements ServerMessage {
    private final long threadId;
    private final byte[] seed;
    private final long capabilities;
    private final short defaultCollation;
    private final short serverStatus;
    private final String authenticationPluginType;

    private InitialHandshakePacket(long threadId, byte[] seed, long capabilities, short defaultCollation, short serverStatus, String authenticationPluginType) {
        this.threadId = threadId;
        this.seed = seed;
        this.capabilities = capabilities;
        this.defaultCollation = defaultCollation;
        this.serverStatus = serverStatus;
        this.authenticationPluginType = authenticationPluginType;
    }

    public static InitialHandshakePacket decode(ReadableByteBuf reader) {
        byte[] seed;
        byte protocolVersion = reader.readByte();
        if (protocolVersion != 10) {
            throw new IllegalArgumentException(String.format("Unexpected initial handshake protocol value [%s]", protocolVersion));
        }
        reader.readStringNullEnd();
        long threadId = reader.readInt();
        byte[] seed1 = new byte[8];
        reader.readBytes(seed1);
        reader.skip();
        int serverCapabilities2FirstBytes = reader.readUnsignedShort();
        short defaultCollation = reader.readUnsignedByte();
        short serverStatus = reader.readShort();
        int serverCapabilities4FirstBytes = serverCapabilities2FirstBytes + (reader.readShort() << 16);
        int saltLength = 0;
        if ((serverCapabilities4FirstBytes & 0x80000) != 0) {
            saltLength = Math.max(12, reader.readByte() - 9);
        } else {
            reader.skip();
        }
        reader.skip(6);
        long singleStoreDbAdditionalCapacities = reader.readInt();
        if ((serverCapabilities4FirstBytes & 0x8000) != 0) {
            byte[] seed2;
            if (saltLength > 0) {
                seed2 = new byte[saltLength];
                reader.readBytes(seed2);
            } else {
                seed2 = reader.readBytesNullEnd();
            }
            seed = new byte[seed1.length + seed2.length];
            System.arraycopy(seed1, 0, seed, 0, seed1.length);
            System.arraycopy(seed2, 0, seed, seed1.length, seed2.length);
        } else {
            seed = seed1;
        }
        reader.skip();
        long serverCapabilities = (serverCapabilities4FirstBytes & 1) == 0 ? ((long)serverCapabilities4FirstBytes & 0xFFFFFFFFL) + (singleStoreDbAdditionalCapacities << 32) : (long)serverCapabilities4FirstBytes & 0xFFFFFFFFL;
        String authenticationPluginType = null;
        if ((serverCapabilities4FirstBytes & 0x80000) != 0) {
            authenticationPluginType = reader.readStringNullEnd();
        }
        return new InitialHandshakePacket(threadId, seed, serverCapabilities |= 0x200000L, defaultCollation, serverStatus, authenticationPluginType);
    }

    public long getThreadId() {
        return this.threadId;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public long getCapabilities() {
        return this.capabilities;
    }

    public short getDefaultCollation() {
        return this.defaultCollation;
    }

    public short getServerStatus() {
        return this.serverStatus;
    }

    public String getAuthenticationPluginType() {
        return this.authenticationPluginType;
    }
}

