/*
 * Decompiled with CFR 0.152.
 */
package com.singlestore.jdbc.plugin.credential.browser.keyring;

import com.singlestore.jdbc.plugin.credential.browser.ExpiringCredential;
import com.singlestore.jdbc.plugin.credential.browser.keyring.Keyring;
import com.singlestore.jdbc.util.log.Logger;
import com.singlestore.jdbc.util.log.Loggers;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class MacKeyring
implements Keyring {
    private static final String ACCOUNT = "SingleStore";
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private final SecurityLibrary secLib = LibManager.getInstance();
    private final Logger logger = Loggers.getLogger(MacKeyring.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExpiringCredential getCredential() {
        byte[] serviceBytes = "SingleStore JDBC Safe Storage".getBytes(CHARSET);
        byte[] userBytes = ACCOUNT.getBytes(CHARSET);
        int[] dataLength = new int[1];
        Pointer[] data = new Pointer[1];
        try {
            int status = 0;
            Object object = this.secLib;
            synchronized (object) {
                status = this.secLib.SecKeychainFindGenericPassword(null, serviceBytes.length, serviceBytes, userBytes.length, userBytes, dataLength, data, null);
            }
            if (status != 0) {
                this.logger.debug("Could not read from the OS X Keychain or the key does not exist. Error code: " + Native.getLastError());
                object = null;
                return object;
            }
            if (dataLength[0] == 0 || data[0] == null) {
                this.logger.debug("Found an empty blob when reading from the OS X Keychain");
                object = null;
                return object;
            }
            object = Keyring.fromBlob(new String(data[0].getByteArray(0L, dataLength[0]), CHARSET));
            return object;
        }
        finally {
            if (data[0] != null) {
                SecurityLibrary securityLibrary = this.secLib;
                synchronized (securityLibrary) {
                    this.secLib.SecKeychainItemFreeContent(null, data[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCredential(ExpiringCredential cred) {
        int status;
        byte[] credBlob = Keyring.makeBlob(cred).getBytes(CHARSET);
        byte[] serviceBytes = "SingleStore JDBC Safe Storage".getBytes(CHARSET);
        byte[] userBytes = ACCOUNT.getBytes(CHARSET);
        Pointer[] itemRef = new Pointer[1];
        SecurityLibrary securityLibrary = this.secLib;
        synchronized (securityLibrary) {
            status = this.secLib.SecKeychainFindGenericPassword(null, serviceBytes.length, serviceBytes, userBytes.length, userBytes, null, null, itemRef);
        }
        if (status != 0 && status != -25300) {
            this.logger.debug("Could not check the existence of key in the OS X Keychain. Error code: " + Native.getLastError());
            return;
        }
        if (itemRef[0] != null) {
            securityLibrary = this.secLib;
            synchronized (securityLibrary) {
                status = this.secLib.SecKeychainItemModifyContent(itemRef[0], null, credBlob.length, credBlob);
            }
        }
        securityLibrary = this.secLib;
        synchronized (securityLibrary) {
            status = this.secLib.SecKeychainAddGenericPassword(Pointer.NULL, serviceBytes.length, serviceBytes, userBytes.length, userBytes, credBlob.length, credBlob, null);
        }
        if (status != 0) {
            this.logger.debug("Could not set/modify the item in the OS X Keychain. Error code: " + Native.getLastError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCredential() {
        byte[] serviceBytes = "SingleStore JDBC Safe Storage".getBytes(CHARSET);
        byte[] userBytes = ACCOUNT.getBytes(CHARSET);
        Pointer[] itemRef = new Pointer[1];
        int status = 0;
        SecurityLibrary securityLibrary = this.secLib;
        synchronized (securityLibrary) {
            status = this.secLib.SecKeychainFindGenericPassword(null, serviceBytes.length, serviceBytes, userBytes.length, userBytes, null, null, itemRef);
        }
        if (status != 0 && status != -25300) {
            this.logger.debug("Could not check the existence of key in the OS X Keychain. Error code: " + Native.getLastError());
            return;
        }
        if (itemRef[0] == null) {
            return;
        }
        securityLibrary = this.secLib;
        synchronized (securityLibrary) {
            status = this.secLib.SecKeychainItemDelete(itemRef[0]);
        }
        if (status != 0) {
            this.logger.info("Could not delete the key from the OS X Keychain. Error code = " + Native.getLastError());
        }
    }

    private static class LibManager {
        private LibManager() {
        }

        public static SecurityLibrary getInstance() {
            return LazyHolder.INSTANCE;
        }

        private static class LazyHolder {
            private static final SecurityLibrary INSTANCE = (SecurityLibrary)Native.load((String)"Security", SecurityLibrary.class);

            private LazyHolder() {
            }
        }
    }

    static interface SecurityLibrary
    extends Library {
        public static final int ERR_SEC_SUCCESS = 0;
        public static final int ERR_SEC_ITEM_NOT_FOUND = -25300;

        public int SecKeychainFindGenericPassword(Pointer var1, int var2, byte[] var3, int var4, byte[] var5, int[] var6, Pointer[] var7, Pointer[] var8);

        public int SecKeychainAddGenericPassword(Pointer var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, Pointer var8);

        public int SecKeychainItemModifyContent(Pointer var1, Pointer var2, int var3, byte[] var4);

        public int SecKeychainItemDelete(Pointer var1);

        public int SecKeychainItemFreeContent(Pointer[] var1, Pointer var2);
    }
}

