/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import io.trino.orc.AbstractOrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcReaderOptions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileOrcDataSource
extends AbstractOrcDataSource {
    private final RandomAccessFile input;

    public FileOrcDataSource(File path, OrcReaderOptions options) throws FileNotFoundException {
        super(new OrcDataSourceId(path.getPath()), path.length(), options);
        this.input = new RandomAccessFile(path, "r");
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    protected void readInternal(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.input.seek(position);
        this.input.readFully(buffer, bufferOffset, bufferLength);
    }
}

