/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.metadata.statistics;

import com.google.common.base.MoreObjects;
import io.airlift.slice.SizeOf;
import io.trino.orc.metadata.statistics.StatisticsHasher;
import java.util.Objects;

public class BooleanStatistics
implements StatisticsHasher.Hashable {
    public static final long BOOLEAN_VALUE_BYTES = 2L;
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(BooleanStatistics.class);
    private final long trueValueCount;

    public BooleanStatistics(long trueValueCount) {
        this.trueValueCount = trueValueCount;
    }

    public long getTrueValueCount() {
        return this.trueValueCount;
    }

    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanStatistics that = (BooleanStatistics)o;
        return this.trueValueCount == that.trueValueCount;
    }

    public int hashCode() {
        return Objects.hash(this.trueValueCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("trueValueCount", this.trueValueCount).toString();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        hasher.putLong(this.trueValueCount);
    }
}

