/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.reader;

import com.google.common.base.Preconditions;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.OrcBlockFactory;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcReader;
import io.trino.orc.metadata.OrcType;
import io.trino.orc.reader.BooleanColumnReader;
import io.trino.orc.reader.ByteColumnReader;
import io.trino.orc.reader.ColumnReader;
import io.trino.orc.reader.DecimalColumnReader;
import io.trino.orc.reader.DoubleColumnReader;
import io.trino.orc.reader.FloatColumnReader;
import io.trino.orc.reader.ListColumnReader;
import io.trino.orc.reader.LongColumnReader;
import io.trino.orc.reader.MapColumnReader;
import io.trino.orc.reader.ReaderUtils;
import io.trino.orc.reader.SliceColumnReader;
import io.trino.orc.reader.StructColumnReader;
import io.trino.orc.reader.TimeColumnReader;
import io.trino.orc.reader.TimestampColumnReader;
import io.trino.orc.reader.UnionColumnReader;
import io.trino.orc.reader.UuidColumnReader;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;

public final class ColumnReaders {
    public static final String ICEBERG_BINARY_TYPE = "iceberg.binary-type";
    public static final String ICEBERG_LONG_TYPE = "iceberg.long-type";

    private ColumnReaders() {
    }

    public static ColumnReader createColumnReader(Type type, OrcColumn column, OrcReader.ProjectedLayout projectedLayout, AggregatedMemoryContext memoryContext, OrcBlockFactory blockFactory, OrcReader.FieldMapperFactory fieldMapperFactory) throws OrcCorruptionException {
        OrcType.OrcTypeKind orcTypeKind = column.getColumnType().getOrcTypeKind();
        if (type instanceof TimeType) {
            if (!type.equals((Object)TimeType.TIME_MICROS) || orcTypeKind != OrcType.OrcTypeKind.LONG || !"TIME".equals(column.getAttributes().get(ICEBERG_LONG_TYPE))) {
                throw ReaderUtils.invalidStreamType(column, type);
            }
            return new TimeColumnReader(type, column, memoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
        }
        if (type instanceof UuidType) {
            Preconditions.checkArgument((orcTypeKind == OrcType.OrcTypeKind.BINARY ? 1 : 0) != 0, (String)"UUID type can only be read from BINARY column but got %s", (Object)column);
            Preconditions.checkArgument((boolean)"UUID".equals(column.getAttributes().get(ICEBERG_BINARY_TYPE)), (String)"Expected ORC column for UUID data to be annotated with %s=UUID: %s", (Object)ICEBERG_BINARY_TYPE, (Object)column);
            return new UuidColumnReader(column);
        }
        return switch (orcTypeKind) {
            default -> throw new MatchException(null, null);
            case OrcType.OrcTypeKind.BOOLEAN -> new BooleanColumnReader(type, column, memoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            case OrcType.OrcTypeKind.BYTE -> {
                if (type == IntegerType.INTEGER && !column.getAttributes().containsKey("iceberg.id")) {
                    throw ReaderUtils.invalidStreamType(column, type);
                }
                yield new ByteColumnReader(type, column, memoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            }
            case OrcType.OrcTypeKind.SHORT, OrcType.OrcTypeKind.INT, OrcType.OrcTypeKind.LONG, OrcType.OrcTypeKind.DATE -> new LongColumnReader(type, column, memoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            case OrcType.OrcTypeKind.FLOAT -> new FloatColumnReader(type, column, memoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            case OrcType.OrcTypeKind.DOUBLE -> new DoubleColumnReader(type, column, memoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            case OrcType.OrcTypeKind.BINARY, OrcType.OrcTypeKind.STRING, OrcType.OrcTypeKind.VARCHAR, OrcType.OrcTypeKind.CHAR -> new SliceColumnReader(type, column, memoryContext);
            case OrcType.OrcTypeKind.TIMESTAMP, OrcType.OrcTypeKind.TIMESTAMP_INSTANT -> new TimestampColumnReader(type, column, memoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            case OrcType.OrcTypeKind.LIST -> new ListColumnReader(type, column, memoryContext, blockFactory, fieldMapperFactory);
            case OrcType.OrcTypeKind.STRUCT -> new StructColumnReader(type, column, projectedLayout, memoryContext, blockFactory, fieldMapperFactory);
            case OrcType.OrcTypeKind.MAP -> new MapColumnReader(type, column, memoryContext, blockFactory, fieldMapperFactory);
            case OrcType.OrcTypeKind.DECIMAL -> new DecimalColumnReader(type, column, memoryContext.newLocalMemoryContext(ColumnReaders.class.getSimpleName()));
            case OrcType.OrcTypeKind.UNION -> new UnionColumnReader(type, column, memoryContext, blockFactory, fieldMapperFactory);
        };
    }
}

