/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.openlineage;

import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.trino.plugin.openlineage.OpenLineageTransport;
import io.trino.plugin.openlineage.OpenLineageTrinoFacet;
import io.trino.spi.resourcegroups.QueryType;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.util.Optional;
import java.util.Set;

public class OpenLineageListenerConfig {
    private OpenLineageTransport transport = OpenLineageTransport.CONSOLE;
    private URI trinoURI;
    private Set<OpenLineageTrinoFacet> disabledFacets = ImmutableSet.of();
    private Optional<String> namespace = Optional.empty();
    private Set<QueryType> includeQueryTypes = ImmutableSet.builder().add((Object)QueryType.ALTER_TABLE_EXECUTE).add((Object)QueryType.DELETE).add((Object)QueryType.INSERT).add((Object)QueryType.MERGE).add((Object)QueryType.UPDATE).add((Object)QueryType.DATA_DEFINITION).build();

    public OpenLineageTransport getTransport() {
        return this.transport;
    }

    @Config(value="openlineage-event-listener.transport.type")
    @ConfigDescription(value="Type of transport used to emit lineage information.")
    public OpenLineageListenerConfig setTransport(OpenLineageTransport transport) {
        this.transport = transport;
        return this;
    }

    @NotNull
    public URI getTrinoURI() {
        return this.trinoURI;
    }

    @Config(value="openlineage-event-listener.trino.uri")
    @ConfigDescription(value="URI of trino server. Used for namespace rendering.")
    public OpenLineageListenerConfig setTrinoURI(URI trinoURI) {
        this.trinoURI = trinoURI;
        return this;
    }

    public Set<QueryType> getIncludeQueryTypes() {
        return this.includeQueryTypes;
    }

    @Config(value="openlineage-event-listener.trino.include-query-types")
    @ConfigDescription(value="Which query types emitted by Trino should generate OpenLineage events. Other query types will be filtered out.")
    public OpenLineageListenerConfig setIncludeQueryTypes(Set<QueryType> includeQueryTypes) {
        this.includeQueryTypes = ImmutableSet.copyOf(includeQueryTypes);
        return this;
    }

    public Set<OpenLineageTrinoFacet> getDisabledFacets() {
        return this.disabledFacets;
    }

    @Config(value="openlineage-event-listener.disabled-facets")
    @ConfigDescription(value="Which facets should be removed from OpenLineage events.")
    public OpenLineageListenerConfig setDisabledFacets(Set<OpenLineageTrinoFacet> disabledFacets) throws RuntimeException {
        this.disabledFacets = ImmutableSet.copyOf(disabledFacets);
        return this;
    }

    public Optional<String> getNamespace() {
        return this.namespace;
    }

    @Config(value="openlineage-event-listener.namespace")
    @ConfigDescription(value="Override default namespace for job facet.")
    public OpenLineageListenerConfig setNamespace(String namespace) {
        this.namespace = Optional.ofNullable(namespace);
        return this;
    }
}

