/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.openlineage.transport.http;

import com.google.inject.Inject;
import io.openlineage.client.transports.HttpConfig;
import io.openlineage.client.transports.HttpTransport;
import io.openlineage.client.transports.TokenProvider;
import io.trino.plugin.openlineage.transport.OpenLineageTransport;
import io.trino.plugin.openlineage.transport.http.OpenLineageHttpTransportConfig;
import java.net.URI;
import java.util.Map;

public class OpenLineageHttpTransport
implements OpenLineageTransport {
    private final URI url;
    private final String endpoint;
    private final int timeout;
    private final TokenProvider tokenProvider;
    private final Map<String, String> urlParams;
    private final Map<String, String> headers;

    @Inject
    public OpenLineageHttpTransport(OpenLineageHttpTransportConfig config) {
        this.url = config.getUrl();
        this.endpoint = config.getEndpoint();
        this.timeout = Math.toIntExact(config.getTimeout().toMillis());
        this.tokenProvider = config.getApiKey().map(OpenLineageHttpTransport::createTokenProvider).orElse(null);
        this.urlParams = config.getUrlParams();
        this.headers = config.getHeaders();
    }

    public HttpTransport buildTransport() {
        return new HttpTransport(new HttpConfig(this.url, this.endpoint, null, Integer.valueOf(this.timeout), this.tokenProvider, this.urlParams, this.headers, null));
    }

    private static TokenProvider createTokenProvider(String token) {
        return () -> "Bearer " + token;
    }
}

