/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.eventlistener.mysql;

import com.mysql.cj.jdbc.Driver;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigSecuritySensitive;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import java.sql.SQLException;

public class MysqlEventListenerConfig {
    private String url;

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @ConfigSecuritySensitive
    @Config(value="mysql-event-listener.db.url")
    public MysqlEventListenerConfig setUrl(String url) {
        this.url = url;
        return this;
    }

    @AssertTrue(message="Invalid JDBC URL for MySQL event listener")
    public @AssertTrue(message="Invalid JDBC URL for MySQL event listener") boolean isValidUrl() {
        try {
            return new Driver().acceptsURL(this.getUrl());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

