/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.eventlistener.mysql;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.mysql.cj.jdbc.Driver;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.ConfigBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.json.JsonModule;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.eventlistener.mysql.MysqlEventListener;
import io.trino.plugin.eventlistener.mysql.MysqlEventListenerConfig;
import io.trino.plugin.eventlistener.mysql.QueryDao;
import io.trino.spi.TrinoWarning;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.EventListenerFactory;
import io.trino.spi.eventlistener.QueryInputMetadata;
import io.trino.spi.eventlistener.QueryOutputMetadata;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jdbi.v3.core.ConnectionFactory;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.opentelemetry.JdbiOpenTelemetryPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;

public class MysqlEventListenerFactory
implements EventListenerFactory {
    public String getName() {
        return "mysql";
    }

    public EventListener create(Map<String, String> config, EventListenerFactory.EventListenerContext context) {
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new MysqlDataSourceModule(), binder -> {
            binder.bind(OpenTelemetry.class).toInstance((Object)context.getOpenTelemetry());
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec((TypeLiteral)new TypeLiteral<Set<String>>(this){});
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindMapJsonCodec(String.class, String.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindListJsonCodec(QueryInputMetadata.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryOutputMetadata.class);
            JsonCodecBinder.jsonCodecBinder((Binder)binder).bindListJsonCodec(TrinoWarning.class);
            binder.bind(QueryDao.class).toProvider(QueryDaoProvider.class).in(Scopes.SINGLETON);
            binder.bind(MysqlEventListener.class).in(Scopes.SINGLETON);
        }});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
        return (EventListener)injector.getInstance(MysqlEventListener.class);
    }

    private static class MysqlDataSourceModule
    implements Module {
        private MysqlDataSourceModule() {
        }

        public void configure(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(MysqlEventListenerConfig.class);
        }

        @Singleton
        @Provides
        public ConnectionFactory createConnectionFactory(MysqlEventListenerConfig config) {
            return () -> new Driver().connect(config.getUrl(), new Properties());
        }

        @Singleton
        @Provides
        public static Jdbi createJdbi(ConnectionFactory connectionFactory, OpenTelemetry openTelemetry) {
            return Jdbi.create((ConnectionFactory)connectionFactory).installPlugin((JdbiPlugin)new SqlObjectPlugin()).installPlugin((JdbiPlugin)new JdbiOpenTelemetryPlugin(openTelemetry));
        }
    }

    private static class QueryDaoProvider
    implements Provider<QueryDao> {
        private final QueryDao dao;

        @Inject
        public QueryDaoProvider(Jdbi jdbi) {
            this.dao = (QueryDao)jdbi.installPlugin((JdbiPlugin)new SqlObjectPlugin()).onDemand(QueryDao.class);
        }

        public QueryDao get() {
            return this.dao;
        }
    }
}

