/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.apachehttpclient.v5_2;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.apachehttpclient.v5_2.ApacheHttpClient5Request;
import io.opentelemetry.instrumentation.apachehttpclient.v5_2.HttpHeaderSetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientRequestResendCount;
import java.io.IOException;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;

@Deprecated
class OtelExecChainHandlerOld
implements ExecChainHandler {
    private static final String REQUEST_PARENT_CONTEXT_ATTRIBUTE_ID = OtelExecChainHandlerOld.class.getName() + ".context";
    private final Instrumenter<ApacheHttpClient5Request, HttpResponse> instrumenter;
    private final ContextPropagators propagators;

    public OtelExecChainHandlerOld(Instrumenter<ApacheHttpClient5Request, HttpResponse> instrumenter, ContextPropagators propagators) {
        this.instrumenter = instrumenter;
        this.propagators = propagators;
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        ApacheHttpClient5Request instrumenterRequest;
        Context parentContext = (Context)scope.clientContext.getAttribute(REQUEST_PARENT_CONTEXT_ATTRIBUTE_ID, Context.class);
        request.setVersion(scope.clientContext.getProtocolVersion());
        if (parentContext == null) {
            parentContext = HttpClientRequestResendCount.initialize((Context)Context.current());
            scope.clientContext.setAttribute(REQUEST_PARENT_CONTEXT_ATTRIBUTE_ID, (Object)parentContext);
        }
        if (!this.instrumenter.shouldStart(parentContext, (Object)(instrumenterRequest = OtelExecChainHandlerOld.getApacheHttpClient5Request(request, scope)))) {
            return chain.proceed(request, scope);
        }
        Context context = this.instrumenter.start(parentContext, (Object)instrumenterRequest);
        this.propagators.getTextMapPropagator().inject(context, (Object)request, (TextMapSetter)HttpHeaderSetter.INSTANCE);
        return this.execute(request, instrumenterRequest, chain, scope, context);
    }

    private ClassicHttpResponse execute(ClassicHttpRequest request, ApacheHttpClient5Request instrumenterRequest, ExecChain chain, ExecChain.Scope scope, Context context) throws IOException, HttpException {
        ClassicHttpResponse response = null;
        Exception error = null;
        try {
            ClassicHttpResponse classicHttpResponse;
            block11: {
                Scope ignored = context.makeCurrent();
                try {
                    classicHttpResponse = response = chain.proceed(request, scope);
                    if (ignored == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        error = e;
                        throw e;
                    }
                }
                ignored.close();
            }
            return classicHttpResponse;
        }
        finally {
            this.instrumenter.end(context, (Object)instrumenterRequest, (Object)response, (Throwable)error);
        }
    }

    private static ApacheHttpClient5Request getApacheHttpClient5Request(ClassicHttpRequest request, ExecChain.Scope scope) {
        HttpHost host = null;
        if (scope.route.getTargetHost() != null) {
            host = scope.route.getTargetHost();
        } else if (scope.clientContext.getHttpRoute().getTargetHost() != null) {
            host = scope.clientContext.getHttpRoute().getTargetHost();
        }
        if (host != null && (host.getSchemeName().equals("https") && host.getPort() == 443 || host.getSchemeName().equals("http") && host.getPort() == 80)) {
            host = new HttpHost(host.getSchemeName(), host.getHostName(), -1);
        }
        return new ApacheHttpClient5Request(host, (HttpRequest)request);
    }
}

