/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.ClassInfo;
import io.airlift.bytecode.ParameterizedType;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.CheckClassAdapter;

public class ClassInfoLoader {
    private final Map<ParameterizedType, ClassNode> classNodes;
    private final Map<ParameterizedType, byte[]> bytecodes;
    private final Loader loader;
    private final Map<ParameterizedType, ClassInfo> classInfoCache = new HashMap<ParameterizedType, ClassInfo>();
    private final boolean loadMethodNodes;

    public static ClassInfoLoader createClassInfoLoader(ClassDefinition classDefinition, MethodHandles.Lookup lookup) {
        ClassNode classNode = new ClassNode();
        classDefinition.visit((ClassVisitor)classNode);
        return new ClassInfoLoader((Map<ParameterizedType, ClassNode>)ImmutableMap.of((Object)classDefinition.getType(), (Object)classNode), (Map<ParameterizedType, byte[]>)ImmutableMap.of(), new LookupLoader(lookup), true);
    }

    public static ClassInfoLoader createClassInfoLoader(Iterable<ClassDefinition> classDefinitions, ClassLoader classLoader) {
        ImmutableMap.Builder classNodes = ImmutableMap.builder();
        for (ClassDefinition classDefinition : classDefinitions) {
            ClassNode classNode = new ClassNode();
            classDefinition.visit((ClassVisitor)classNode);
            classNodes.put((Object)classDefinition.getType(), (Object)classNode);
        }
        return new ClassInfoLoader((Map<ParameterizedType, ClassNode>)classNodes.build(), (Map<ParameterizedType, byte[]>)ImmutableMap.of(), new ClassLoaderLoader(classLoader), true);
    }

    private ClassInfoLoader(Map<ParameterizedType, ClassNode> classNodes, Map<ParameterizedType, byte[]> bytecodes, Loader loader, boolean loadMethodNodes) {
        this.classNodes = ImmutableMap.copyOf(classNodes);
        this.bytecodes = ImmutableMap.copyOf(bytecodes);
        this.loader = loader;
        this.loadMethodNodes = loadMethodNodes;
    }

    public ClassInfo loadClassInfo(ParameterizedType type) {
        ClassInfo classInfo = this.classInfoCache.get(type);
        if (classInfo == null) {
            classInfo = this.readClassInfoQuick(type);
            this.classInfoCache.put(type, classInfo);
        }
        return classInfo;
    }

    private ClassInfo readClassInfoQuick(ParameterizedType type) {
        ClassReader classReader;
        ClassNode classNode = this.classNodes.get(type);
        if (classNode != null) {
            return new ClassInfo(this, classNode);
        }
        byte[] bytecode = this.bytecodes.get(type);
        if (bytecode != null) {
            classReader = new ClassReader(bytecode);
        } else {
            classReader = this.loader.createByteCodeClassReader(type).orElse(null);
            if (classReader == null) {
                return new ClassInfo(this, this.loader.loadClass(type));
            }
        }
        if (this.loadMethodNodes) {
            classNode = new ClassNode();
            classReader.accept((ClassVisitor)new CheckClassAdapter((ClassVisitor)classNode, false), 2);
            return new ClassInfo(this, classNode);
        }
        int header = classReader.header;
        int access = classReader.readUnsignedShort(header);
        char[] buf = new char[2048];
        int superClassIndex = classReader.getItem(classReader.readUnsignedShort(header + 4));
        ParameterizedType superClass = superClassIndex == 0 ? null : ParameterizedType.typeFromPathName(classReader.readUTF8(superClassIndex, buf));
        int interfaceCount = classReader.readUnsignedShort(header + 6);
        ImmutableList.Builder interfaces = ImmutableList.builder();
        header += 8;
        for (int i = 0; i < interfaceCount; ++i) {
            interfaces.add((Object)ParameterizedType.typeFromPathName(classReader.readClass(header, buf)));
            header += 2;
        }
        return new ClassInfo(this, type, access, superClass, (Iterable<ParameterizedType>)interfaces.build(), null);
    }

    private static class LookupLoader
    implements Loader {
        private final MethodHandles.Lookup lookup;

        public LookupLoader(MethodHandles.Lookup lookup) {
            this.lookup = Objects.requireNonNull(lookup, "lookup is null");
        }

        @Override
        public Optional<ClassReader> createByteCodeClassReader(ParameterizedType type) {
            return Optional.empty();
        }

        @Override
        public Class<?> loadClass(ParameterizedType type) {
            try {
                return this.lookup.findClass(type.getJavaClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException e) {
                throw new RuntimeException("Class not found " + type, e);
            }
        }
    }

    private static interface Loader {
        public Optional<ClassReader> createByteCodeClassReader(ParameterizedType var1);

        public Class<?> loadClass(ParameterizedType var1);
    }

    private static class ClassLoaderLoader
    implements Loader {
        private final ClassLoader classLoader;

        public ClassLoaderLoader(ClassLoader classLoader) {
            this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Optional<ClassReader> createByteCodeClassReader(ParameterizedType type) {
            String classFileName = type.getClassName() + ".class";
            try (InputStream inputStream = this.classLoader.getResourceAsStream(classFileName);){
                if (inputStream == null) {
                    Optional<ClassReader> optional2 = Optional.empty();
                    return optional2;
                }
                Optional<ClassReader> optional = Optional.of(new ClassReader(inputStream));
                return optional;
            }
            catch (IOException ignored) {
                return Optional.empty();
            }
        }

        @Override
        public Class<?> loadClass(ParameterizedType type) {
            try {
                return this.classLoader.loadClass(type.getJavaClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class not found " + type, e);
            }
        }
    }
}

