/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.Column;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.Table;
import io.trino.metastore.TableInfo;
import io.trino.plugin.base.classloader.ClassLoaderSafeSystemTable;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hudi.HudiErrorCode;
import io.trino.plugin.hudi.HudiPredicates;
import io.trino.plugin.hudi.HudiSessionProperties;
import io.trino.plugin.hudi.HudiTableHandle;
import io.trino.plugin.hudi.HudiTableInfo;
import io.trino.plugin.hudi.HudiTableName;
import io.trino.plugin.hudi.HudiUtil;
import io.trino.plugin.hudi.TableType;
import io.trino.plugin.hudi.TimelineTable;
import io.trino.plugin.hudi.model.HudiTableType;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class HudiMetadata
implements ConnectorMetadata {
    private final HiveMetastore metastore;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final TypeManager typeManager;

    public HudiMetadata(HiveMetastore metastore, TrinoFileSystemFactory fileSystemFactory, TypeManager typeManager) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)this.metastore.getAllDatabases().stream().filter(schemaName -> !HiveUtil.isHiveSystemSchema((String)schemaName)).collect(ImmutableList.toImmutableList());
    }

    public HudiTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        if (startVersion.isPresent() || endVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support versioned tables");
        }
        if (HiveUtil.isHiveSystemSchema((String)tableName.getSchemaName())) {
            return null;
        }
        Optional table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (table.isEmpty()) {
            return null;
        }
        if (!HiveUtil.isHudiTable((Table)((Table)table.get()))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_TABLE_TYPE, String.format("Not a Hudi table: %s", tableName));
        }
        Location location = Location.of((String)((Table)table.get()).getStorage().getLocation());
        if (!HudiUtil.hudiMetadataExists(this.fileSystemFactory.create(session), location)) {
            throw new TrinoException((ErrorCodeSupplier)HudiErrorCode.HUDI_BAD_DATA, "Location of table %s does not contain Hudi table metadata: %s".formatted(tableName, location));
        }
        return new HudiTableHandle(tableName.getSchemaName(), tableName.getTableName(), ((Table)table.get()).getStorage().getLocation(), HudiTableType.COPY_ON_WRITE, HiveUtil.getPartitionKeyColumnHandles((Table)((Table)table.get()), (TypeManager)this.typeManager), (TupleDomain<HiveColumnHandle>)TupleDomain.all(), (TupleDomain<HiveColumnHandle>)TupleDomain.all());
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return this.getRawSystemTable(tableName, session).map(systemTable -> new ClassLoaderSafeSystemTable(systemTable, this.getClass().getClassLoader()));
    }

    private Optional<SystemTable> getRawSystemTable(SchemaTableName tableName, ConnectorSession session) {
        HudiTableName name = HudiTableName.from(tableName.getTableName());
        if (name.tableType() == TableType.DATA) {
            return Optional.empty();
        }
        Optional tableOptional = this.metastore.getTable(tableName.getSchemaName(), name.tableName());
        if (tableOptional.isEmpty()) {
            return Optional.empty();
        }
        if (!HiveUtil.isHudiTable((Table)((Table)tableOptional.get()))) {
            return Optional.empty();
        }
        return switch (name.tableType()) {
            default -> throw new MatchException(null, null);
            case TableType.DATA -> Optional.empty();
            case TableType.TIMELINE -> {
                SchemaTableName systemTableName = new SchemaTableName(tableName.getSchemaName(), name.tableNameWithType());
                yield Optional.of(new TimelineTable(this.fileSystemFactory.create(session), systemTableName, (Table)tableOptional.get()));
            }
        };
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        HudiTableHandle hudiTableHandle = (HudiTableHandle)table;
        return this.getTableMetadata(hudiTableHandle.getSchemaTableName(), HudiSessionProperties.getColumnsToHide(session));
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        HudiTableHandle handle = (HudiTableHandle)tableHandle;
        HudiPredicates predicates = HudiPredicates.from((TupleDomain<ColumnHandle>)constraint.getSummary());
        TupleDomain<HiveColumnHandle> regularColumnPredicates = predicates.getRegularColumnPredicates();
        TupleDomain<HiveColumnHandle> partitionColumnPredicates = predicates.getPartitionColumnPredicates();
        Set newConstraintColumns = (Set)Stream.concat(Stream.concat(regularColumnPredicates.getDomains().stream().map(Map::keySet).flatMap(Collection::stream), partitionColumnPredicates.getDomains().stream().map(Map::keySet).flatMap(Collection::stream)), handle.getConstraintColumns().stream()).collect(ImmutableSet.toImmutableSet());
        HudiTableHandle newHudiTableHandle = handle.applyPredicates(newConstraintColumns, partitionColumnPredicates, regularColumnPredicates);
        if (handle.getPartitionPredicates().equals(newHudiTableHandle.getPartitionPredicates()) && handle.getRegularPredicates().equals(newHudiTableHandle.getRegularPredicates()) && handle.getConstraintColumns().equals(newHudiTableHandle.getConstraintColumns())) {
            return Optional.empty();
        }
        return Optional.of(new ConstraintApplicationResult((Object)newHudiTableHandle, newHudiTableHandle.getRegularPredicates().transformKeys(ColumnHandle.class::cast), constraint.getExpression(), false));
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HudiTableHandle hudiTableHandle = (HudiTableHandle)tableHandle;
        Table table = (Table)this.metastore.getTable(hudiTableHandle.getSchemaName(), hudiTableHandle.getTableName()).orElseThrow(() -> new TableNotFoundException(SchemaTableName.schemaTableName((String)hudiTableHandle.getSchemaName(), (String)hudiTableHandle.getTableName())));
        return (Map)HiveUtil.hiveColumnHandles((Table)table, (TypeManager)this.typeManager, (HiveTimestampPrecision)HiveTimestampPrecision.NANOSECONDS).stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, Function.identity()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((HiveColumnHandle)columnHandle).getColumnMetadata();
    }

    public Optional<Object> getInfo(ConnectorTableHandle tableHandle) {
        HudiTableHandle table = (HudiTableHandle)tableHandle;
        return Optional.of(new HudiTableInfo(table.getSchemaTableName(), table.getTableType().name(), table.getBasePath()));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> optionalSchemaName) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, optionalSchemaName)) {
            for (TableInfo tableInfo : this.metastore.getTables(schemaName)) {
                tableNames.add((Object)tableInfo.tableName());
            }
        }
        return tableNames.build();
    }

    public Iterator<RelationColumnsMetadata> streamRelationColumns(ConnectorSession session, Optional<String> schemaName, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        SchemaTablePrefix prefix = schemaName.map(SchemaTablePrefix::new).orElseGet(SchemaTablePrefix::new);
        List tables = prefix.getTable().map(string -> Collections.singletonList(prefix.toSchemaTableName())).orElseGet(() -> this.listTables(session, prefix.getSchema()));
        Map relationColumns = (Map)tables.stream().map(table -> this.getTableColumnMetadata(session, (SchemaTableName)table)).flatMap(Optional::stream).collect(ImmutableMap.toImmutableMap(RelationColumnsMetadata::name, Function.identity()));
        return ((Set)relationFilter.apply(relationColumns.keySet())).stream().map(relationColumns::get).iterator();
    }

    public void validateScan(ConnectorSession session, ConnectorTableHandle handle) {
        HudiTableHandle hudiTableHandle = (HudiTableHandle)handle;
        if (HudiSessionProperties.isQueryPartitionFilterRequired(session) && !hudiTableHandle.getPartitionColumns().isEmpty()) {
            Set partitionColumns = (Set)hudiTableHandle.getPartitionColumns().stream().map(HiveColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
            Set constraintColumns = (Set)hudiTableHandle.getConstraintColumns().stream().map(HiveColumnHandle::getBaseColumnName).collect(ImmutableSet.toImmutableSet());
            if (Collections.disjoint(constraintColumns, partitionColumns)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, String.format("Filter required on %s for at least one of the partition columns: %s", hudiTableHandle.getSchemaTableName(), String.join((CharSequence)", ", partitionColumns)));
            }
        }
    }

    public boolean allowSplittingReadIntoMultipleSubQueries(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return true;
    }

    HiveMetastore getMetastore() {
        return this.metastore;
    }

    private Optional<RelationColumnsMetadata> getTableColumnMetadata(ConnectorSession session, SchemaTableName table) {
        try {
            List columns = this.getTableMetadata(table, HudiSessionProperties.getColumnsToHide(session)).getColumns();
            return Optional.of(RelationColumnsMetadata.forTable((SchemaTableName)table, (List)columns));
        }
        catch (TableNotFoundException tableNotFoundException) {
            return Optional.empty();
        }
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName, Collection<String> columnsToHide) {
        List partitionedBy;
        Table table = (Table)this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        Function metadataGetter = HiveUtil.columnMetadataGetter((Table)table);
        List columns = (List)HiveUtil.hiveColumnHandles((Table)table, (TypeManager)this.typeManager, (HiveTimestampPrecision)HiveTimestampPrecision.NANOSECONDS).stream().filter(column -> !columnsToHide.contains(column.getName())).map(metadataGetter).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder properties = ImmutableMap.builder();
        String location = table.getStorage().getLocation();
        if (!Strings.isNullOrEmpty((String)location)) {
            properties.put((Object)"location", (Object)location);
        }
        if (!(partitionedBy = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList())).isEmpty()) {
            properties.put((Object)"partitioned_by", (Object)partitionedBy);
        }
        Optional<String> comment = Optional.ofNullable((String)table.getParameters().get("comment"));
        return new ConnectorTableMetadata(tableName, columns, (Map)properties.buildOrThrow(), comment);
    }

    private List<String> listSchemas(ConnectorSession session, Optional<String> schemaName) {
        return schemaName.filter(name -> !HiveUtil.isHiveSystemSchema((String)name)).map(Collections::singletonList).orElseGet(() -> this.listSchemaNames(session));
    }
}

