/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.ConfigBinder;
import io.trino.metastore.HiveMetastore;
import io.trino.plugin.base.ClosingBinder;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.hive.HiveNodePartitioningProvider;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.plugin.hive.metastore.HiveMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.TranslateHiveViews;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.plugin.hudi.ForHudiSplitManager;
import io.trino.plugin.hudi.ForHudiSplitSource;
import io.trino.plugin.hudi.HudiConfig;
import io.trino.plugin.hudi.HudiMetadataFactory;
import io.trino.plugin.hudi.HudiPageSourceProvider;
import io.trino.plugin.hudi.HudiSessionProperties;
import io.trino.plugin.hudi.HudiSplitManager;
import io.trino.plugin.hudi.HudiTableProperties;
import io.trino.plugin.hudi.HudiTransactionManager;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.security.ConnectorIdentity;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiFunction;
import org.weakref.jmx.guice.ExportBinder;

public class HudiModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(HudiTransactionManager.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(HudiConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(HiveMetastoreConfig.class);
        binder.bind(Key.get(Boolean.TYPE, TranslateHiveViews.class)).toInstance((Object)false);
        Multibinder.newSetBinder((Binder)binder, SessionPropertiesProvider.class).addBinding().to(HudiSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(HudiTableProperties.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorSplitManager.class).to(HudiSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSourceProvider.class).to(HudiPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorNodePartitioningProvider.class).to(HiveNodePartitioningProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ParquetReaderConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ParquetWriterConfig.class);
        binder.bind(HudiMetadataFactory.class).in(Scopes.SINGLETON);
        binder.bind(FileFormatDataSourceStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(FileFormatDataSourceStats.class).withGeneratedName();
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ExecutorService.class, ForHudiSplitManager.class));
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ScheduledExecutorService.class, ForHudiSplitSource.class));
    }

    @Provides
    @Singleton
    @ForHudiSplitManager
    public ExecutorService createExecutorService() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"hudi-split-manager-%s"));
    }

    @Provides
    @Singleton
    @ForHudiSplitSource
    public ScheduledExecutorService createSplitLoaderExecutor(HudiConfig hudiConfig) {
        return Executors.newScheduledThreadPool(hudiConfig.getSplitLoaderParallelism(), Threads.daemonThreadsNamed((String)"hudi-split-loader-%s"));
    }

    @Provides
    @Singleton
    public BiFunction<ConnectorIdentity, HiveTransactionHandle, HiveMetastore> createHiveMetastoreGetter(HudiTransactionManager transactionManager) {
        return (identity, transactionHandle) -> transactionManager.get((ConnectorTransactionHandle)transactionHandle, (ConnectorIdentity)identity).getMetastore();
    }
}

