/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hudi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HudiSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = Math.toIntExact(SizeOf.instanceSize(HudiSplit.class));
    private final String location;
    private final long start;
    private final long length;
    private final long fileSize;
    private final long fileModifiedTime;
    private final TupleDomain<HiveColumnHandle> predicate;
    private final List<HivePartitionKey> partitionKeys;
    private final SplitWeight splitWeight;

    @JsonCreator
    public HudiSplit(@JsonProperty(value="location") String location, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="fileSize") long fileSize, @JsonProperty(value="fileModifiedTime") long fileModifiedTime, @JsonProperty(value="predicate") TupleDomain<HiveColumnHandle> predicate, @JsonProperty(value="partitionKeys") List<HivePartitionKey> partitionKeys, @JsonProperty(value="splitWeight") SplitWeight splitWeight) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start must be positive");
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"length must be positive");
        Preconditions.checkArgument((start + length <= fileSize ? 1 : 0) != 0, (Object)"fileSize must be at least start + length");
        this.location = Objects.requireNonNull(location, "location is null");
        this.start = start;
        this.length = length;
        this.fileSize = fileSize;
        this.fileModifiedTime = fileModifiedTime;
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.partitionKeys = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionKeys, "partitionKeys is null"));
        this.splitWeight = Objects.requireNonNull(splitWeight, "splitWeight is null");
    }

    public Map<String, String> getSplitInfo() {
        return ImmutableMap.builder().put((Object)"location", (Object)this.location).put((Object)"start", (Object)String.valueOf(this.start)).put((Object)"length", (Object)String.valueOf(this.length)).put((Object)"fileSize", (Object)String.valueOf(this.fileSize)).put((Object)"fileModifiedTime", (Object)String.valueOf(this.fileModifiedTime)).buildOrThrow();
    }

    @JsonProperty
    public SplitWeight getSplitWeight() {
        return this.splitWeight;
    }

    @JsonProperty
    public String getLocation() {
        return this.location;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public long getFileSize() {
        return this.fileSize;
    }

    @JsonProperty
    public long getFileModifiedTime() {
        return this.fileModifiedTime;
    }

    @JsonProperty
    public TupleDomain<HiveColumnHandle> getPredicate() {
        return this.predicate;
    }

    @JsonProperty
    public List<HivePartitionKey> getPartitionKeys() {
        return this.partitionKeys;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.location) + this.splitWeight.getRetainedSizeInBytes() + this.predicate.getRetainedSizeInBytes(HiveColumnHandle::getRetainedSizeInBytes) + SizeOf.estimatedSizeOf(this.partitionKeys, HivePartitionKey::estimatedSizeInBytes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.location).addValue(this.start).addValue(this.length).addValue(this.fileSize).addValue(this.fileModifiedTime).toString();
    }
}

